/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties;

import io.camunda.operate.auth.AuthInterface;
import io.camunda.operate.auth.SaasAuthentication;
import io.camunda.operate.auth.SelfManagedAuthentication;
import io.camunda.operate.auth.SimpleAuthentication;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties
public class OperateClientConfigurationProperties {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Value(value="${zeebe.client.cloud.cluster-id:#{null}}")
    private String clusterId;
    @Value(value="${zeebe.client.cloud.region:bru-2}")
    private String region;
    @Value(value="${zeebe.client.cloud.client-id:#{null}}")
    private String clientId;
    @Value(value="${zeebe.client.cloud.client-secret:#{null}}")
    private String clientSecret;
    @Value(value="${zeebe.client.cloud.authUrl:#{null}}")
    private String authUrlZeebe;
    @Value(value="${zeebe.client.cloud.baseUrl:#{null}}")
    private String audienceZeebe;
    public static String DEFAULT_AUTH_URL = "https://login.cloud.camunda.io/oauth/token";
    public static String DEFAULT_AUDIENCE = "operate.camunda.io";
    @Value(value="${camunda.operate.client.authUrl:#{null}}")
    private String authUrlOperate;
    @Value(value="${camunda.operate.client.baseUrl:#{null}}")
    private String audienceOperate;
    @Value(value="${camunda.operate.client.client-id:#{null}}")
    private String operateClientId;
    @Value(value="${camunda.operate.client.client-secret:#{null}}")
    private String operateClientSecret;
    @Value(value="${camunda.operate.client.url:#{null}}")
    private String operateUrl;
    @Value(value="${camunda.operate.client.username:#{null}}")
    private String operateUsername;
    @Value(value="${camunda.operate.client.password:#{null}}")
    private String operatePassword;
    @Value(value="${camunda.operate.client.keycloak-url:#{null}}")
    private String operateKeycloakUrl;
    @Value(value="${camunda.operate.client.keycloak-realm:#{null}}")
    private String operateKeycloakRealm;
    public static String operateCloudBaseUrl = "operate.camunda.io";

    public String getOperateUrl() {
        if (this.operateUrl != null) {
            LOG.debug("Connecting to Camunda Operate on URL: " + this.operateUrl);
            return this.operateUrl;
        }
        if (this.clusterId != null) {
            String url = "https://" + this.region + "." + operateCloudBaseUrl + "/" + this.clusterId + "/";
            LOG.debug("Connecting to Camunda Operate SaaS via URL: " + url);
            return url;
        }
        throw new IllegalArgumentException("In order to connect to Camunda Operate you need to specify either a SaaS clusterId or an Operate URL.");
    }

    public AuthInterface getAuthentication(String operateUrl) {
        if (this.operateKeycloakUrl != null) {
            if (this.operateClientId != null) {
                LOG.debug("Authenticating with Camunda Operate using Keycloak on " + this.operateKeycloakUrl);
                return new SelfManagedAuthentication(this.operateClientId, this.operateClientSecret).keycloakUrl(this.operateKeycloakUrl).keycloakRealm(this.operateKeycloakRealm);
            }
            if (this.clientId != null) {
                LOG.debug("Authenticating with Camunda Operate using Keycloak on " + this.operateKeycloakUrl);
                return new SelfManagedAuthentication(this.clientId, this.clientSecret).keycloakUrl(this.operateKeycloakUrl).keycloakRealm(this.operateKeycloakRealm);
            }
            throw new IllegalArgumentException("Failed to authenticate with Camunda Operate using Keycloak: please configure client ID and client secret values.");
        }
        if (this.operateClientId != null) {
            LOG.debug("Authenticating with Camunda Operate using client id and secret");
            return new SaasAuthentication(this.getAuthUrl(), this.getAudience(), this.operateClientId, this.operateClientSecret);
        }
        if (this.clientId != null) {
            LOG.debug("Authenticating with Camunda Operate using client id and secret");
            return new SaasAuthentication(this.getAuthUrl(), this.getAudience(), this.clientId, this.clientSecret);
        }
        if (this.operateUsername != null && this.operatePassword != null) {
            LOG.debug("Authenticating with Camunda Operate using username and password");
            return new SimpleAuthentication(this.operateUsername, this.operatePassword, operateUrl);
        }
        throw new IllegalArgumentException("In order to connect to Camunda Operate you need to configure authentication properly. You can use password-based authentication, or authenticate with Keycloak. Please configure either one of the methods.");
    }

    public String getAuthUrl() {
        if (this.authUrlOperate != null) {
            return this.authUrlOperate;
        }
        if (this.authUrlZeebe != null) {
            return this.authUrlZeebe;
        }
        return DEFAULT_AUTH_URL;
    }

    public String getAudience() {
        if (this.audienceOperate != null) {
            return this.audienceOperate;
        }
        if (this.audienceZeebe != null) {
            return this.audienceZeebe;
        }
        return DEFAULT_AUDIENCE;
    }
}

