/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.actuator;

import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import io.micrometer.core.instrument.Counter;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MicrometerMetricsRecorder
implements MetricsRecorder {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final MeterRegistry meterRegistry;
    private final Map<String, Counter> counters = new HashMap<String, Counter>();

    public MicrometerMetricsRecorder(MeterRegistry meterRegistry) {
        LOGGER.info("Enabling Micrometer based metrics for spring-zeebe (available via Actuator)");
        this.meterRegistry = meterRegistry;
    }

    protected Counter newCounter(String metricName, String action, String jobType) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        if (action != null && !action.isEmpty()) {
            tags.add(Tag.of((String)"action", (String)action));
        }
        if (jobType != null && !jobType.isEmpty()) {
            tags.add(Tag.of((String)"type", (String)jobType));
        }
        return this.meterRegistry.counter(metricName, tags);
    }

    public void increase(String metricName, String action, String type, int count) {
        String key = metricName + "#" + action + '#' + type;
        if (!this.counters.containsKey(key)) {
            this.counters.put(key, this.newCounter(metricName, action, type));
        }
        this.counters.get(key).increment((double)count);
    }

    public void executeWithTimer(String metricName, String jobType, Runnable methodToExecute) {
        Timer timer = this.meterRegistry.timer(metricName, new String[]{"type", jobType});
        timer.record(methodToExecute);
    }
}

