/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.DefaultNoopAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthentication;
import io.camunda.common.auth.SaaSAuthenticationBuilder;
import io.camunda.common.auth.SelfManagedAuthentication;
import io.camunda.common.auth.SelfManagedAuthenticationBuilder;
import io.camunda.common.auth.SimpleAuthentication;
import io.camunda.common.auth.SimpleConfig;
import io.camunda.common.auth.SimpleCredential;
import io.camunda.common.auth.identity.IdentityConfig;
import io.camunda.common.auth.identity.IdentityContainer;
import io.camunda.common.json.JsonMapper;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.zeebe.spring.client.configuration.JsonMapperConfiguration;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.common.ApiProperties;
import io.camunda.zeebe.spring.client.properties.common.AuthProperties;
import java.net.URL;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;

@Configuration
@EnableConfigurationProperties(value={CamundaClientProperties.class})
@ConditionalOnProperty(prefix="camunda.client", name={"mode"})
@Import(value={JsonMapperConfiguration.class})
public class AuthenticationConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(AuthenticationConfiguration.class);
    private final CamundaClientProperties camundaClientProperties;
    private final JsonMapper jsonMapper;

    @Autowired
    public AuthenticationConfiguration(CamundaClientProperties camundaClientProperties, JsonMapper jsonMapper) {
        this.camundaClientProperties = camundaClientProperties;
        this.jsonMapper = jsonMapper;
    }

    @Bean
    public Authentication camundaAuthentication() {
        CamundaClientProperties.ClientMode clientMode = this.camundaClientProperties.getMode();
        if (CamundaClientProperties.ClientMode.simple.equals((Object)clientMode)) {
            SimpleConfig config = new SimpleConfig();
            for (Product p : Product.coveredProducts()) {
                this.simpleCredentialForProduct(config, p);
            }
            return SimpleAuthentication.builder().withSimpleConfig(config).build();
        }
        if (CamundaClientProperties.ClientMode.oidc.equals((Object)clientMode)) {
            IdentityConfig identityConfig = new IdentityConfig();
            JwtConfig jwtConfig = new JwtConfig();
            for (Product p : Product.coveredProducts()) {
                this.oidcCredentialForProduct(identityConfig, jwtConfig, p);
            }
            return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
        }
        if (CamundaClientProperties.ClientMode.saas.equals((Object)clientMode)) {
            JwtConfig jwtConfig = new JwtConfig();
            for (Product p : Product.coveredProducts()) {
                this.saasCredentialForProduct(jwtConfig, p);
            }
            return ((SaaSAuthenticationBuilder)SaaSAuthentication.builder().withJwtConfig(jwtConfig)).withJsonMapper(this.jsonMapper).build();
        }
        return new DefaultNoopAuthentication();
    }

    private void simpleCredentialForProduct(SimpleConfig config, Product product) {
        if (this.enabledForProduct(product).booleanValue()) {
            LOG.debug("{} is enabled", (Object)product);
            config.addProduct(product, new SimpleCredential(this.baseUrlForProduct(product).toString(), this.username(), this.password()));
        } else {
            LOG.debug("{} is disabled", (Object)product);
        }
    }

    private void oidcCredentialForProduct(IdentityConfig identityConfig, JwtConfig jwtConfig, Product product) {
        if (this.enabledForProduct(product).booleanValue()) {
            LOG.debug("{} is enabled", (Object)product);
            String issuer = this.globalIssuer();
            String clientId = this.clientId();
            String clientSecret = this.clientSecret();
            String audience = this.audienceForProduct(product);
            jwtConfig.addProduct(product, new JwtCredential(clientId, clientSecret, audience, issuer));
            IdentityConfiguration identityCfg = new IdentityConfiguration(this.baseUrlForProduct(Product.IDENTITY).toString(), issuer, issuer, clientId, clientSecret, audience, this.globalOidcType().name());
            identityConfig.addProduct(product, new IdentityContainer(new Identity(identityCfg), identityCfg));
        } else {
            LOG.debug("{} is disabled", (Object)product);
        }
    }

    private void saasCredentialForProduct(JwtConfig jwtConfig, Product product) {
        if (this.enabledForProduct(product).booleanValue()) {
            LOG.debug("{} is enabled", (Object)product);
            String issuer = this.globalIssuer();
            String clientId = this.clientId();
            String clientSecret = this.clientSecret();
            String audience = this.audienceForProduct(product);
            jwtConfig.addProduct(product, new JwtCredential(clientId, clientSecret, audience, issuer));
        } else {
            LOG.debug("{} is disabled", (Object)product);
        }
    }

    private String globalIssuer() {
        return this.getGlobalAuthProperty("issuer", AuthProperties::getIssuer);
    }

    private IdentityConfiguration.Type globalOidcType() {
        return this.getGlobalAuthProperty("oidc type", AuthProperties::getOidcType);
    }

    private <T> T getGlobalAuthProperty(String propertyName, Function<AuthProperties, T> getter) {
        return Optional.ofNullable(this.camundaClientProperties.getAuth()).map(getter).orElseThrow(() -> new IllegalStateException("Could not detect required auth property " + propertyName));
    }

    private Boolean enabledForProduct(Product product) {
        return this.getApiProperty("enabled", product, ApiProperties::getEnabled);
    }

    private URL baseUrlForProduct(Product product) {
        return this.getApiProperty("base url", product, ApiProperties::getBaseUrl);
    }

    private String username() {
        return this.getAuthProperty("username", AuthProperties::getUsername);
    }

    private String password() {
        return this.getAuthProperty("password", AuthProperties::getPassword);
    }

    private String clientId() {
        return this.getAuthProperty("client id", AuthProperties::getClientId);
    }

    private String clientSecret() {
        return this.getAuthProperty("client secret", AuthProperties::getClientSecret);
    }

    private String audienceForProduct(Product product) {
        return this.getApiProperty("audience", product, ApiProperties::getAudience);
    }

    private <T> T getApiProperty(String propertyName, Product product, Function<ApiProperties, T> getter) {
        return this.getApiProperty(product + " " + propertyName, getter, this.apiPropertiesForProduct(product));
    }

    private <T> T getAuthProperty(String propertyName, Function<AuthProperties, T> getter) {
        AuthPropertiesSupplier[] authPropertiesSupplierArray = new AuthPropertiesSupplier[1];
        authPropertiesSupplierArray[0] = this.camundaClientProperties::getAuth;
        return this.getAuthProperty(propertyName, getter, authPropertiesSupplierArray);
    }

    private ApiPropertiesSupplier apiPropertiesForProduct(Product product) {
        return this.apiPropertiesForProduct(this.camundaClientProperties, product);
    }

    private ApiPropertiesSupplier apiPropertiesForProduct(CamundaClientProperties properties, Product product) {
        switch (product) {
            case OPERATE: {
                return properties::getOperate;
            }
            case TASKLIST: {
                return properties::getTasklist;
            }
            case ZEEBE: {
                return properties::getZeebe;
            }
            case OPTIMIZE: {
                return properties::getOptimize;
            }
            case IDENTITY: {
                return properties::getIdentity;
            }
        }
        throw new IllegalStateException("Could not detect auth properties supplier for product " + product);
    }

    private <T> T getApiProperty(String propertyName, Function<ApiProperties, T> getter, ApiPropertiesSupplier ... alternatives) {
        for (ApiPropertiesSupplier supplier : alternatives) {
            T property;
            ApiProperties properties = (ApiProperties)supplier.get();
            if (properties == null || (property = getter.apply(properties)) == null) continue;
            LOG.debug("Detected property {}", (Object)propertyName);
            return property;
        }
        throw new IllegalStateException("Could not detect required property " + propertyName);
    }

    private <T> T getAuthProperty(String propertyName, Function<AuthProperties, T> getter, AuthPropertiesSupplier ... alternatives) {
        for (AuthPropertiesSupplier supplier : alternatives) {
            T property;
            AuthProperties properties = (AuthProperties)supplier.get();
            if (properties == null || (property = getter.apply(properties)) == null) continue;
            LOG.debug("Detected property {}", (Object)propertyName);
            return property;
        }
        throw new IllegalStateException("Could not detect required property " + propertyName);
    }

    private static interface ApiPropertiesSupplier
    extends Supplier<ApiProperties> {
    }

    private static interface AuthPropertiesSupplier
    extends Supplier<AuthProperties> {
    }
}

