/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.DefaultNoopAuthentication;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SimpleAuthentication;
import io.camunda.zeebe.client.CredentialsProvider;
import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.impl.oauth.OAuthCredentialsProviderBuilder;
import io.camunda.zeebe.client.impl.util.Environment;
import io.camunda.zeebe.spring.client.configuration.PropertyUtil;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.PropertiesUtil;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class ZeebeClientConfiguration
implements io.camunda.zeebe.client.ZeebeClientConfiguration {
    private static final Logger LOG = LoggerFactory.getLogger(ZeebeClientConfiguration.class);
    private final Map<String, Object> configCache = new HashMap<String, Object>();
    private final ZeebeClientConfigurationProperties properties;
    private final CamundaClientProperties camundaClientProperties;
    private final Authentication authentication;
    private final JsonMapper jsonMapper;
    private final List<ClientInterceptor> interceptors;
    private final ZeebeClientExecutorService zeebeClientExecutorService;

    @Autowired
    public ZeebeClientConfiguration(ZeebeClientConfigurationProperties properties, CamundaClientProperties camundaClientProperties, Authentication authentication, JsonMapper jsonMapper, List<ClientInterceptor> interceptors, ZeebeClientExecutorService zeebeClientExecutorService) {
        this.properties = properties;
        this.camundaClientProperties = camundaClientProperties;
        this.authentication = authentication;
        this.jsonMapper = jsonMapper;
        this.interceptors = interceptors;
        this.zeebeClientExecutorService = zeebeClientExecutorService;
    }

    @PostConstruct
    public void applyLegacy() {
        this.properties.applyOverrides();
    }

    public String getGatewayAddress() {
        return PropertyUtil.getOrLegacyOrDefault("GatewayAddress", this::composeGatewayAddress, () -> PropertiesUtil.getZeebeGatewayAddress(this.properties), ZeebeClientConfigurationProperties.DEFAULT.getGatewayAddress(), this.configCache);
    }

    private String composeGatewayAddress() {
        if (this.camundaClientProperties.getZeebe().getBaseUrl().getPort() != -1) {
            String gatewayAddress = this.camundaClientProperties.getZeebe().getBaseUrl().getHost() + ":" + this.camundaClientProperties.getZeebe().getBaseUrl().getPort();
            LOG.debug("Gateway port is set, address will be '{}'", (Object)gatewayAddress);
            return gatewayAddress;
        }
        if (this.camundaClientProperties.getZeebe().getBaseUrl().getDefaultPort() != -1) {
            String gatewayAddress = this.camundaClientProperties.getZeebe().getBaseUrl().getHost() + ":" + this.camundaClientProperties.getZeebe().getBaseUrl().getDefaultPort();
            LOG.debug("Gateway port has default, address will be '{}'", (Object)gatewayAddress);
            return gatewayAddress;
        }
        LOG.debug("Gateway cannot be determined, address will be '{}'", (Object)this.camundaClientProperties.getZeebe().getBaseUrl().getHost());
        return this.camundaClientProperties.getZeebe().getBaseUrl().getHost();
    }

    public String getDefaultTenantId() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultTenantId", PropertyUtil.prioritized(ZeebeClientConfigurationProperties.DEFAULT.getDefaultTenantId(), Arrays.asList(() -> this.camundaClientProperties.getTenantIds().get(0), () -> (String)this.camundaClientProperties.getZeebe().getDefaults().getTenantIds().get(0))), this.properties::getDefaultTenantId, ZeebeClientConfigurationProperties.DEFAULT.getDefaultTenantId(), this.configCache);
    }

    public List<String> getDefaultJobWorkerTenantIds() {
        Supplier[] supplierArray = new Supplier[2];
        supplierArray[0] = this.camundaClientProperties::getTenantIds;
        supplierArray[1] = () -> this.camundaClientProperties.getZeebe().getDefaults().getTenantIds();
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerTenantIds", PropertyUtil.prioritized(ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerTenantIds(), Arrays.asList(supplierArray)), this.properties::getDefaultJobWorkerTenantIds, ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerTenantIds(), this.configCache);
    }

    public int getNumJobWorkerExecutionThreads() {
        return PropertyUtil.getOrLegacyOrDefault("NumJobWorkerExecutionThreads", () -> this.camundaClientProperties.getZeebe().getExecutionThreads(), () -> this.properties.getWorker().getThreads(), ZeebeClientConfigurationProperties.DEFAULT.getNumJobWorkerExecutionThreads(), this.configCache);
    }

    public int getDefaultJobWorkerMaxJobsActive() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerMaxJobsActive", () -> this.camundaClientProperties.getZeebe().getDefaults().getMaxJobsActive(), () -> this.properties.getWorker().getMaxJobsActive(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerMaxJobsActive(), this.configCache);
    }

    public String getDefaultJobWorkerName() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerName", () -> this.camundaClientProperties.getZeebe().getDefaults().getName(), () -> this.properties.getWorker().getDefaultName(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerName(), this.configCache);
    }

    public Duration getDefaultJobTimeout() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobTimeout", () -> this.camundaClientProperties.getZeebe().getDefaults().getTimeout(), () -> this.properties.getJob().getTimeout(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobTimeout(), this.configCache);
    }

    public Duration getDefaultJobPollInterval() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobPollInterval", () -> this.camundaClientProperties.getZeebe().getDefaults().getPollInterval(), () -> this.properties.getJob().getPollInterval(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobPollInterval(), this.configCache);
    }

    public Duration getDefaultMessageTimeToLive() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultMessageTimeToLive", () -> this.camundaClientProperties.getZeebe().getMessageTimeToLive(), () -> this.properties.getMessage().getTimeToLive(), ZeebeClientConfigurationProperties.DEFAULT.getDefaultMessageTimeToLive(), this.configCache);
    }

    public Duration getDefaultRequestTimeout() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultRequestTimeout", PropertyUtil.prioritized(ZeebeClientConfigurationProperties.DEFAULT.getDefaultRequestTimeout(), Arrays.asList(() -> this.camundaClientProperties.getZeebe().getRequestTimeout(), () -> this.camundaClientProperties.getZeebe().getDefaults().getRequestTimeout())), this.properties::getRequestTimeout, ZeebeClientConfigurationProperties.DEFAULT.getDefaultRequestTimeout(), this.configCache);
    }

    public boolean isPlaintextConnectionEnabled() {
        return PropertyUtil.getOrLegacyOrDefault("PlaintextConnectionEnabled", this::composePlaintext, () -> this.properties.getSecurity().isPlaintext(), ZeebeClientConfigurationProperties.DEFAULT.isPlaintextConnectionEnabled(), this.configCache);
    }

    private boolean composePlaintext() {
        String protocol = this.camundaClientProperties.getZeebe().getBaseUrl().getProtocol();
        if (protocol.equals("http")) {
            return true;
        }
        if (protocol.equals("https")) {
            return false;
        }
        throw new IllegalStateException(String.format("Unrecognized zeebe protocol '%s'", this.camundaClientProperties.getZeebe().getBaseUrl().getProtocol()));
    }

    public String getCaCertificatePath() {
        return PropertyUtil.getOrLegacyOrDefault("CaCertificatePath", () -> this.camundaClientProperties.getZeebe().getCaCertificatePath(), () -> this.properties.getSecurity().getCertPath(), ZeebeClientConfigurationProperties.DEFAULT.getCaCertificatePath(), this.configCache);
    }

    public CredentialsProvider getCredentialsProvider() {
        return PropertyUtil.getOrLegacyOrDefault("CredentialsProvider", this::identityCredentialsProvider, this::legacyCredentialsProvider, null, this.configCache);
    }

    private CredentialsProvider identityCredentialsProvider() {
        if (this.authentication instanceof SimpleAuthentication) {
            return null;
        }
        if (!(this.authentication instanceof DefaultNoopAuthentication)) {
            return new IdentityCredentialsProvider(this.authentication);
        }
        return null;
    }

    private CredentialsProvider legacyCredentialsProvider() {
        if (StringUtils.hasText((String)this.properties.getCloud().getClientId()) && StringUtils.hasText((String)this.properties.getCloud().getClientSecret())) {
            return CredentialsProvider.newCredentialsProviderBuilder().clientId(this.properties.getCloud().getClientId()).clientSecret(this.properties.getCloud().getClientSecret()).audience(this.properties.getCloud().getAudience()).scope(this.properties.getCloud().getScope()).authorizationServerUrl(this.properties.getCloud().getAuthUrl()).credentialsCachePath(this.properties.getCloud().getCredentialsCachePath()).build();
        }
        if (Environment.system().get("ZEEBE_CLIENT_ID") != null && Environment.system().get("ZEEBE_CLIENT_SECRET") != null) {
            OAuthCredentialsProviderBuilder builder = CredentialsProvider.newCredentialsProviderBuilder();
            int separatorIndex = this.properties.getBroker().getGatewayAddress().lastIndexOf(58);
            if (separatorIndex > 0) {
                builder.audience(this.properties.getBroker().getGatewayAddress().substring(0, separatorIndex));
            }
            return builder.build();
        }
        return null;
    }

    public Duration getKeepAlive() {
        return PropertyUtil.getOrLegacyOrDefault("KeepAlive", () -> this.camundaClientProperties.getZeebe().getKeepAlive(), () -> this.properties.getBroker().getKeepAlive(), ZeebeClientConfigurationProperties.DEFAULT.getKeepAlive(), this.configCache);
    }

    public List<ClientInterceptor> getInterceptors() {
        return this.interceptors;
    }

    public JsonMapper getJsonMapper() {
        return this.jsonMapper;
    }

    public String getOverrideAuthority() {
        return PropertyUtil.getOrLegacyOrDefault("OverrideAuthority", () -> this.camundaClientProperties.getZeebe().getOverrideAuthority(), () -> this.properties.getSecurity().getOverrideAuthority(), ZeebeClientConfigurationProperties.DEFAULT.getOverrideAuthority(), this.configCache);
    }

    public int getMaxMessageSize() {
        return PropertyUtil.getOrLegacyOrDefault("MaxMessageSize", () -> this.camundaClientProperties.getZeebe().getMaxMessageSize(), () -> this.properties.getMessage().getMaxMessageSize(), ZeebeClientConfigurationProperties.DEFAULT.getMaxMessageSize(), this.configCache);
    }

    public ScheduledExecutorService jobWorkerExecutor() {
        return this.zeebeClientExecutorService.get();
    }

    public boolean ownsJobWorkerExecutor() {
        return PropertyUtil.getOrLegacyOrDefault("ownsJobWorkerExecutor", () -> ((ZeebeClientExecutorService)this.zeebeClientExecutorService).isOwnedByZeebeClient(), this.properties::ownsJobWorkerExecutor, ZeebeClientConfigurationProperties.DEFAULT.ownsJobWorkerExecutor(), this.configCache);
    }

    public boolean getDefaultJobWorkerStreamEnabled() {
        return PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerStreamEnabled", () -> this.camundaClientProperties.getZeebe().getDefaults().getStreamEnabled(), this.properties::getDefaultJobWorkerStreamEnabled, ZeebeClientConfigurationProperties.DEFAULT.getDefaultJobWorkerStreamEnabled(), this.configCache);
    }

    public boolean useDefaultRetryPolicy() {
        return false;
    }

    public String toString() {
        return "ZeebeClientConfiguration{properties=" + this.properties + ", camundaClientProperties=" + this.camundaClientProperties + ", authentication=" + this.authentication + ", jsonMapper=" + this.jsonMapper + ", interceptors=" + this.interceptors + ", zeebeClientExecutorService=" + this.zeebeClientExecutorService + '}';
    }

    public static class IdentityCredentialsProvider
    implements CredentialsProvider {
        private final Authentication authentication;

        public IdentityCredentialsProvider(Authentication authentication) {
            this.authentication = authentication;
        }

        public void applyCredentials(Metadata headers) {
            Map.Entry authHeader = this.authentication.getTokenHeader(Product.ZEEBE);
            Metadata.Key authHeaderKey = Metadata.Key.of((String)((String)authHeader.getKey()), (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
            headers.put(authHeaderKey, (Object)((String)authHeader.getValue()));
        }

        public boolean shouldRetryRequest(Throwable throwable) {
            return ((StatusRuntimeException)throwable).getStatus() == Status.DEADLINE_EXCEEDED;
        }
    }
}

