/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties;

import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PropertiesUtil {
    private static final Logger LOG = LoggerFactory.getLogger(PropertiesUtil.class);

    public static String getZeebeGatewayAddress(ZeebeClientConfigurationProperties properties) {
        String connectionMode = properties.getConnectionMode();
        if (connectionMode != null && !connectionMode.isEmpty()) {
            LOG.info("Using connection mode '{}' to connect to Zeebe", (Object)connectionMode);
            if ("CLOUD".equalsIgnoreCase(connectionMode)) {
                return properties.getCloud().getGatewayAddress();
            }
            if ("ADDRESS".equalsIgnoreCase(connectionMode)) {
                return properties.getBroker().getGatewayAddress();
            }
            throw new RuntimeException("Value '" + connectionMode + "' for ConnectionMode is invalid, valid values are " + "CLOUD" + " or " + "ADDRESS");
        }
        if (properties.getCloud().isConfigured()) {
            return properties.getCloud().getGatewayAddress();
        }
        return properties.getBroker().getGatewayAddress();
    }
}

