/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.properties;

import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.spring.client.annotation.Variable;
import io.camunda.zeebe.spring.client.annotation.VariablesAsType;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariable;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariablesAsType;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeWorkerValue;
import io.camunda.zeebe.spring.client.bean.CopyNotNullBeanUtilsBean;
import io.camunda.zeebe.spring.client.bean.MethodInfo;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import io.camunda.zeebe.spring.client.configuration.PropertyUtil;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.common.ZeebeClientProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ReflectionUtils;

public class PropertyBasedZeebeWorkerValueCustomizer
implements ZeebeWorkerValueCustomizer {
    private static final Logger LOG = LoggerFactory.getLogger(PropertyBasedZeebeWorkerValueCustomizer.class);
    private static final CopyNotNullBeanUtilsBean BEAN_UTILS_BEAN = new CopyNotNullBeanUtilsBean();
    private final ZeebeClientConfigurationProperties zeebeClientConfigurationProperties;
    private final CamundaClientProperties camundaClientProperties;

    public PropertyBasedZeebeWorkerValueCustomizer(ZeebeClientConfigurationProperties zeebeClientConfigurationProperties, CamundaClientProperties camundaClientProperties) {
        this.zeebeClientConfigurationProperties = zeebeClientConfigurationProperties;
        this.camundaClientProperties = camundaClientProperties;
    }

    public void customize(ZeebeWorkerValue zeebeWorker) {
        this.applyDefaultWorkerName(zeebeWorker);
        this.applyDefaultJobWorkerType(zeebeWorker);
        this.applyFetchVariables(zeebeWorker);
        this.applyOverrides(zeebeWorker);
    }

    private void applyFetchVariables(ZeebeWorkerValue zeebeWorkerValue) {
        if (this.hasActivatedJobInjected(zeebeWorkerValue)) {
            LOG.debug("Worker '{}': ActivatedJob is injected, no variable filtering possible", (Object)zeebeWorkerValue.getName());
        } else if (zeebeWorkerValue.getForceFetchAllVariables() != null && zeebeWorkerValue.getForceFetchAllVariables().booleanValue()) {
            LOG.debug("Worker '{}': Force fetch all variables is enabled", (Object)zeebeWorkerValue.getName());
            zeebeWorkerValue.setFetchVariables(Collections.emptyList());
        } else {
            HashSet<String> variables = new HashSet<String>();
            if (zeebeWorkerValue.getFetchVariables() != null) {
                variables.addAll(zeebeWorkerValue.getFetchVariables());
            }
            variables.addAll(this.readZeebeVariableParameters(zeebeWorkerValue.getMethodInfo()).stream().map(this::extractVariableName).collect(Collectors.toList()));
            variables.addAll(this.readVariablesAsTypeParameters(zeebeWorkerValue.getMethodInfo()));
            zeebeWorkerValue.setFetchVariables(variables.stream().collect(Collectors.toList()));
            LOG.debug("Worker '{}': Fetching only required variables {}", (Object)zeebeWorkerValue.getName(), variables);
        }
    }

    private boolean hasActivatedJobInjected(ZeebeWorkerValue zeebeWorkerValue) {
        return zeebeWorkerValue.getMethodInfo().getParameters().stream().anyMatch(p -> p.getParameterInfo().getType().isAssignableFrom(ActivatedJob.class));
    }

    private List<ParameterInfo> readZeebeVariableParameters(MethodInfo methodInfo) {
        List result = methodInfo.getParametersFilteredByAnnotation(Variable.class);
        result.addAll(methodInfo.getParametersFilteredByAnnotation(ZeebeVariable.class));
        return result;
    }

    private String extractVariableName(ParameterInfo parameterInfo) {
        Variable variableAnnotation = parameterInfo.getParameterInfo().getAnnotation(Variable.class);
        if (variableAnnotation != null && !"$NULL$".equals(variableAnnotation.name())) {
            return variableAnnotation.name();
        }
        return parameterInfo.getParameterName();
    }

    private List<String> readVariablesAsTypeParameters(MethodInfo methodInfo) {
        ArrayList<String> result = new ArrayList<String>();
        List parameters = methodInfo.getParametersFilteredByAnnotation(VariablesAsType.class);
        parameters.addAll(methodInfo.getParametersFilteredByAnnotation(ZeebeVariablesAsType.class));
        parameters.forEach(pi -> ReflectionUtils.doWithFields(pi.getParameterInfo().getType(), f -> result.add(f.getName())));
        return result;
    }

    private void applyOverrides(ZeebeWorkerValue zeebeWorker) {
        Map workerConfigurationMap = PropertyUtil.getOrLegacyOrDefault("Override", () -> this.camundaClientProperties.getZeebe().getOverride(), () -> this.zeebeClientConfigurationProperties.getWorker().getOverride(), new HashMap(), null);
        try {
            if (Optional.ofNullable(this.camundaClientProperties.getZeebe()).map(ZeebeClientProperties::getDefaults).isPresent()) {
                BEAN_UTILS_BEAN.copyProperties((Object)zeebeWorker, (Object)this.camundaClientProperties.getZeebe().getDefaults());
            }
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException("Error while copying properties from " + this.camundaClientProperties.getZeebe().getDefaults() + " to " + zeebeWorker, e);
        }
        String workerType = zeebeWorker.getType();
        if (workerConfigurationMap.containsKey(workerType)) {
            ZeebeWorkerValue zeebeWorkerValue = (ZeebeWorkerValue)workerConfigurationMap.get(workerType);
            LOG.debug("Worker '{}': Applying overrides {}", (Object)workerType, (Object)zeebeWorkerValue);
            try {
                BEAN_UTILS_BEAN.copyProperties((Object)zeebeWorker, (Object)zeebeWorkerValue);
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException("Error while copying properties from " + zeebeWorkerValue + " to " + zeebeWorker, e);
            }
        }
    }

    private void applyDefaultWorkerName(ZeebeWorkerValue zeebeWorker) {
        String defaultJobWorkerName = PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerName", () -> this.camundaClientProperties.getZeebe().getDefaults().getName(), this.zeebeClientConfigurationProperties::getDefaultJobWorkerName, null, null);
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getName())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerName)) {
                LOG.debug("Worker '{}': Setting name to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerName);
                zeebeWorker.setName(defaultJobWorkerName);
            } else {
                String generatedJobWorkerName = zeebeWorker.getMethodInfo().getBeanName() + "#" + zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting name to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerName);
                zeebeWorker.setName(generatedJobWorkerName);
            }
        }
    }

    private void applyDefaultJobWorkerType(ZeebeWorkerValue zeebeWorker) {
        String defaultJobWorkerType = PropertyUtil.getOrLegacyOrDefault("DefaultJobWorkerType", () -> this.camundaClientProperties.getZeebe().getDefaults().getType(), this.zeebeClientConfigurationProperties::getDefaultJobWorkerType, null, null);
        if (StringUtils.isBlank((CharSequence)zeebeWorker.getType())) {
            if (StringUtils.isNotBlank((CharSequence)defaultJobWorkerType)) {
                LOG.debug("Worker '{}': Setting type to default {}", (Object)zeebeWorker.getName(), (Object)defaultJobWorkerType);
                zeebeWorker.setType(defaultJobWorkerType);
            } else {
                String generatedJobWorkerType = zeebeWorker.getMethodInfo().getMethodName();
                LOG.debug("Worker '{}': Setting type to generated {}", (Object)zeebeWorker.getName(), (Object)generatedJobWorkerType);
                zeebeWorker.setType(generatedJobWorkerType);
            }
        }
    }
}

