/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.common.auth.Authentication;
import io.camunda.common.auth.DefaultNoopAuthentication;
import io.camunda.common.auth.JwtConfig;
import io.camunda.common.auth.JwtCredential;
import io.camunda.common.auth.Product;
import io.camunda.common.auth.SaaSAuthentication;
import io.camunda.common.auth.SaaSAuthenticationBuilder;
import io.camunda.common.auth.SelfManagedAuthentication;
import io.camunda.common.auth.SelfManagedAuthenticationBuilder;
import io.camunda.common.auth.SimpleAuthentication;
import io.camunda.common.auth.SimpleConfig;
import io.camunda.common.auth.SimpleCredential;
import io.camunda.common.auth.identity.IdentityConfig;
import io.camunda.common.auth.identity.IdentityContainer;
import io.camunda.common.exception.SdkException;
import io.camunda.common.json.JsonMapper;
import io.camunda.identity.sdk.Identity;
import io.camunda.identity.sdk.IdentityConfiguration;
import io.camunda.zeebe.spring.client.properties.CommonConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ConsoleClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.OperateClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.OptimizeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.TasklistClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import io.camunda.zeebe.spring.client.properties.ZeebeSelfManagedProperties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.util.StringUtils;

@EnableConfigurationProperties(value={CommonConfigurationProperties.class, ZeebeSelfManagedProperties.class})
@Deprecated
public class CommonClientConfiguration {
    @Autowired(required=false)
    CommonConfigurationProperties commonConfigurationProperties;
    @Autowired(required=false)
    ZeebeClientConfigurationProperties zeebeClientConfigurationProperties;
    @Autowired(required=false)
    ConsoleClientConfigurationProperties consoleClientConfigurationProperties;
    @Autowired(required=false)
    OptimizeClientConfigurationProperties optimizeClientConfigurationProperties;
    @Autowired(required=false)
    TasklistClientConfigurationProperties tasklistClientConfigurationProperties;
    @Autowired(required=false)
    OperateClientConfigurationProperties operateClientConfigurationProperties;
    @Autowired(required=false)
    ZeebeSelfManagedProperties zeebeSelfManagedProperties;
    @Autowired(required=false)
    private IdentityConfiguration identityConfigurationFromProperties;

    @Bean
    @ConditionalOnMissingBean
    public Authentication authentication(JsonMapper jsonMapper) {
        if (this.zeebeClientConfigurationProperties != null) {
            if (this.zeebeClientConfigurationProperties.getCloud().getClusterId() != null) {
                return ((SaaSAuthenticationBuilder)SaaSAuthentication.builder().withJwtConfig(this.configureJwtConfig())).withJsonMapper(jsonMapper).build();
            }
            if (this.zeebeClientConfigurationProperties.getBroker().getGatewayAddress() != null || this.zeebeSelfManagedProperties.getGatewayAddress() != null) {
                if (this.operateClientConfigurationProperties != null) {
                    if (StringUtils.hasText((String)this.operateClientConfigurationProperties.getKeycloakUrl()) || StringUtils.hasText((String)this.operateClientConfigurationProperties.getKeycloakTokenUrl())) {
                        JwtConfig jwtConfig = this.configureJwtConfig();
                        IdentityConfig identityConfig = this.configureIdentities(jwtConfig);
                        return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
                    }
                    if (this.operateClientConfigurationProperties.getUsername() != null && this.operateClientConfigurationProperties.getPassword() != null) {
                        SimpleConfig simpleConfig = new SimpleConfig();
                        SimpleCredential simpleCredential = new SimpleCredential(this.operateClientConfigurationProperties.getOperateUrl(), this.operateClientConfigurationProperties.getUsername(), this.operateClientConfigurationProperties.getPassword());
                        simpleConfig.addProduct(Product.OPERATE, simpleCredential);
                        return SimpleAuthentication.builder().withSimpleConfig(simpleConfig).build();
                    }
                }
                if (this.identityConfigurationFromProperties != null && StringUtils.hasText((String)this.identityConfigurationFromProperties.getClientId())) {
                    JwtConfig jwtConfig = this.configureJwtConfig();
                    IdentityConfig identityConfig = this.configureIdentities(jwtConfig);
                    return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
                }
                if (this.commonConfigurationProperties != null) {
                    if (this.commonConfigurationProperties.getKeycloak().getUrl() != null) {
                        JwtConfig jwtConfig = this.configureJwtConfig();
                        IdentityConfig identityConfig = this.configureIdentities(jwtConfig);
                        return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
                    }
                    if (this.commonConfigurationProperties.getKeycloak().getTokenUrl() != null) {
                        JwtConfig jwtConfig = this.configureJwtConfig();
                        IdentityConfig identityConfig = this.configureIdentities(jwtConfig);
                        return ((SelfManagedAuthenticationBuilder)SelfManagedAuthentication.builder().withJwtConfig(jwtConfig)).withIdentityConfig(identityConfig).build();
                    }
                    if (this.commonConfigurationProperties.getUsername() != null && this.commonConfigurationProperties.getPassword() != null) {
                        SimpleConfig simpleConfig = new SimpleConfig();
                        SimpleCredential simpleCredential = new SimpleCredential(this.getUrl(this.commonConfigurationProperties), this.commonConfigurationProperties.getUsername(), this.commonConfigurationProperties.getPassword());
                        simpleConfig.addProduct(Product.OPERATE, simpleCredential);
                        return SimpleAuthentication.builder().withSimpleConfig(simpleConfig).build();
                    }
                }
            }
        }
        return new DefaultNoopAuthentication();
    }

    private String getUrl(CommonConfigurationProperties commonConfigurationProperties) {
        if (commonConfigurationProperties.getUrl() != null) {
            return commonConfigurationProperties.getUrl();
        }
        if (commonConfigurationProperties.getBaseUrl() != null) {
            return commonConfigurationProperties.getBaseUrl();
        }
        return null;
    }

    private JwtConfig configureJwtConfig() {
        JwtConfig jwtConfig = new JwtConfig();
        if (this.zeebeClientConfigurationProperties.getCloud().getClientId() != null && this.zeebeClientConfigurationProperties.getCloud().getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.zeebeClientConfigurationProperties.getCloud().getClientId(), this.zeebeClientConfigurationProperties.getCloud().getClientSecret(), this.zeebeClientConfigurationProperties.getCloud().getAudience(), this.zeebeClientConfigurationProperties.getCloud().getAuthUrl()));
        } else if (this.zeebeSelfManagedProperties.getClientId() != null && this.zeebeSelfManagedProperties.getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.zeebeSelfManagedProperties.getClientId(), this.zeebeSelfManagedProperties.getClientSecret(), this.zeebeSelfManagedProperties.getAudience(), this.zeebeSelfManagedProperties.getAuthServer()));
        } else if (this.commonConfigurationProperties.getClientId() != null && this.commonConfigurationProperties.getClientSecret() != null) {
            jwtConfig.addProduct(Product.ZEEBE, new JwtCredential(this.commonConfigurationProperties.getClientId(), this.commonConfigurationProperties.getClientSecret(), this.zeebeClientConfigurationProperties.getCloud().getAudience(), this.zeebeClientConfigurationProperties.getCloud().getAuthUrl()));
        }
        Object operateAuthUrl = this.zeebeClientConfigurationProperties.getCloud().getAuthUrl();
        String operateAudience = "operate.camunda.io";
        if (this.operateClientConfigurationProperties != null) {
            if (this.operateClientConfigurationProperties.getAuthUrl() != null) {
                operateAuthUrl = this.operateClientConfigurationProperties.getAuthUrl();
            } else if (StringUtils.hasText((String)this.operateClientConfigurationProperties.getKeycloakTokenUrl())) {
                operateAuthUrl = this.operateClientConfigurationProperties.getKeycloakTokenUrl();
            } else if (StringUtils.hasText((String)this.operateClientConfigurationProperties.getKeycloakUrl()) && StringUtils.hasText((String)this.operateClientConfigurationProperties.getKeycloakRealm())) {
                operateAuthUrl = this.operateClientConfigurationProperties.getKeycloakUrl() + "/auth/realms/" + this.operateClientConfigurationProperties.getKeycloakRealm();
            }
            if (this.operateClientConfigurationProperties.getBaseUrl() != null) {
                operateAudience = this.operateClientConfigurationProperties.getBaseUrl();
            }
            if (this.operateClientConfigurationProperties.getClientId() != null && this.operateClientConfigurationProperties.getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.operateClientConfigurationProperties.getClientId(), this.operateClientConfigurationProperties.getClientSecret(), operateAudience, (String)operateAuthUrl));
            } else if (this.identityConfigurationFromProperties != null && StringUtils.hasText((String)this.identityConfigurationFromProperties.getClientId()) && StringUtils.hasText((String)this.identityConfigurationFromProperties.getClientSecret())) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.identityConfigurationFromProperties.getClientId(), this.identityConfigurationFromProperties.getClientSecret(), this.identityConfigurationFromProperties.getAudience(), this.identityConfigurationFromProperties.getIssuerBackendUrl()));
            } else if (this.commonConfigurationProperties.getClientId() != null && this.commonConfigurationProperties.getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.commonConfigurationProperties.getClientId(), this.commonConfigurationProperties.getClientSecret(), operateAudience, (String)operateAuthUrl));
            } else if (this.zeebeClientConfigurationProperties.getCloud().getClientId() != null && this.zeebeClientConfigurationProperties.getCloud().getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.zeebeClientConfigurationProperties.getCloud().getClientId(), this.zeebeClientConfigurationProperties.getCloud().getClientSecret(), operateAudience, (String)operateAuthUrl));
            } else if (this.zeebeSelfManagedProperties.getClientId() != null && this.zeebeSelfManagedProperties.getClientSecret() != null) {
                jwtConfig.addProduct(Product.OPERATE, new JwtCredential(this.zeebeSelfManagedProperties.getClientId(), this.zeebeSelfManagedProperties.getClientSecret(), operateAudience, (String)operateAuthUrl));
            } else {
                throw new SdkException("Unable to determine OPERATE credentials");
            }
        }
        return jwtConfig;
    }

    private IdentityConfig configureIdentities(JwtConfig jwtConfig) {
        IdentityConfig identityConfig = new IdentityConfig();
        if (this.operateClientConfigurationProperties != null) {
            IdentityContainer operateIdentityContainer = this.configureOperateIdentityContainer(jwtConfig);
            identityConfig.addProduct(Product.OPERATE, operateIdentityContainer);
        }
        return identityConfig;
    }

    private IdentityContainer configureOperateIdentityContainer(JwtConfig jwtConfig) {
        String issuer = StringUtils.hasText((String)this.identityConfigurationFromProperties.getIssuer()) ? this.identityConfigurationFromProperties.getIssuer() : jwtConfig.getProduct(Product.OPERATE).getAuthUrl();
        String issuerBackendUrl = StringUtils.hasText((String)this.identityConfigurationFromProperties.getIssuerBackendUrl()) ? this.identityConfigurationFromProperties.getIssuerBackendUrl() : jwtConfig.getProduct(Product.OPERATE).getAuthUrl();
        IdentityConfiguration operateIdentityConfiguration = new IdentityConfiguration.Builder().withBaseUrl(this.identityConfigurationFromProperties.getBaseUrl()).withIssuer(issuer).withIssuerBackendUrl(issuerBackendUrl).withClientId(jwtConfig.getProduct(Product.OPERATE).getClientId()).withClientSecret(jwtConfig.getProduct(Product.OPERATE).getClientSecret()).withAudience(jwtConfig.getProduct(Product.OPERATE).getAudience()).withType(this.identityConfigurationFromProperties.getType().name()).build();
        Identity operateIdentity = new Identity(operateIdentityConfiguration);
        return new IdentityContainer(operateIdentity, operateIdentityConfiguration);
    }
}

