/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.configuration;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.worker.BackoffSupplier;
import io.camunda.zeebe.client.impl.worker.ExponentialBackoffBuilderImpl;
import io.camunda.zeebe.spring.client.annotation.customizer.ZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.annotation.processor.AnnotationProcessorConfiguration;
import io.camunda.zeebe.spring.client.configuration.JsonMapperConfiguration;
import io.camunda.zeebe.spring.client.configuration.PropertyUtil;
import io.camunda.zeebe.spring.client.configuration.condition.ZeebeClientCondition;
import io.camunda.zeebe.spring.client.jobhandling.CommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.DefaultCommandExceptionHandlingStrategy;
import io.camunda.zeebe.spring.client.jobhandling.JobWorkerManager;
import io.camunda.zeebe.spring.client.jobhandling.ZeebeClientExecutorService;
import io.camunda.zeebe.spring.client.jobhandling.parameter.DefaultParameterResolverStrategy;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.zeebe.spring.client.metrics.MetricsRecorder;
import io.camunda.zeebe.spring.client.properties.CamundaClientProperties;
import io.camunda.zeebe.spring.client.properties.PropertyBasedZeebeWorkerValueCustomizer;
import io.camunda.zeebe.spring.client.properties.ZeebeClientConfigurationProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Import;

@Conditional(value={ZeebeClientCondition.class})
@Import(value={AnnotationProcessorConfiguration.class, JsonMapperConfiguration.class})
@EnableConfigurationProperties(value={ZeebeClientConfigurationProperties.class, CamundaClientProperties.class})
public class ZeebeClientAllAutoConfiguration {
    private final ZeebeClientConfigurationProperties configurationProperties;
    private final CamundaClientProperties camundaClientProperties;

    public ZeebeClientAllAutoConfiguration(ZeebeClientConfigurationProperties configurationProperties, CamundaClientProperties camundaClientProperties) {
        this.configurationProperties = configurationProperties;
        this.camundaClientProperties = camundaClientProperties;
    }

    @Bean
    @ConditionalOnMissingBean
    public ZeebeClientExecutorService zeebeClientExecutorService() {
        return ZeebeClientExecutorService.createDefault((int)PropertyUtil.getOrLegacyOrDefault("NumJobWorkerExecutionThreads", () -> this.camundaClientProperties.getZeebe().getExecutionThreads(), this.configurationProperties::getNumJobWorkerExecutionThreads, ZeebeClientConfigurationProperties.DEFAULT.getNumJobWorkerExecutionThreads(), null));
    }

    @Bean
    @ConditionalOnMissingBean
    public CommandExceptionHandlingStrategy commandExceptionHandlingStrategy(ZeebeClientExecutorService scheduledExecutorService) {
        return new DefaultCommandExceptionHandlingStrategy(this.backoffSupplier(), scheduledExecutorService.get());
    }

    @Bean
    @ConditionalOnMissingBean
    public ParameterResolverStrategy parameterResolverStrategy(JsonMapper jsonMapper) {
        return new DefaultParameterResolverStrategy(jsonMapper);
    }

    @Bean
    public JobWorkerManager jobWorkerManager(CommandExceptionHandlingStrategy commandExceptionHandlingStrategy, MetricsRecorder metricsRecorder, ParameterResolverStrategy parameterResolverStrategy) {
        return new JobWorkerManager(commandExceptionHandlingStrategy, metricsRecorder, parameterResolverStrategy);
    }

    @Bean
    public BackoffSupplier backoffSupplier() {
        return new ExponentialBackoffBuilderImpl().maxDelay(1000L).minDelay(50L).backoffFactor(1.5).jitterFactor(0.2).build();
    }

    @Bean(value={"propertyBasedZeebeWorkerValueCustomizer"})
    @ConditionalOnMissingBean(name={"propertyBasedZeebeWorkerValueCustomizer"})
    public ZeebeWorkerValueCustomizer propertyBasedZeebeWorkerValueCustomizer() {
        return new PropertyBasedZeebeWorkerValueCustomizer(this.configurationProperties, this.camundaClientProperties);
    }
}

