/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.annotation.value;

import io.camunda.zeebe.spring.client.annotation.Variable;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariable;
import io.camunda.zeebe.spring.client.annotation.value.ZeebeAnnotationValue;
import io.camunda.zeebe.spring.client.bean.CopyNotNullBeanUtilsBean;
import io.camunda.zeebe.spring.client.bean.MethodInfo;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import java.lang.reflect.InvocationTargetException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class ZeebeWorkerValue
implements ZeebeAnnotationValue<MethodInfo> {
    private static final CopyNotNullBeanUtilsBean BEAN_UTILS_BEAN = new CopyNotNullBeanUtilsBean();
    private String type;
    private String name;
    private Long timeout;
    private Integer maxJobsActive;
    private Long requestTimeout;
    private Long pollInterval;
    private Boolean autoComplete;
    private String[] fetchVariables;
    private Boolean enabled;
    private MethodInfo methodInfo;

    public ZeebeWorkerValue() {
    }

    private ZeebeWorkerValue(String type, String name, long timeout, int maxJobsActive, long requestTimeout, long pollInterval, String[] fetchVariables, boolean forceFetchAllVariables, List<ParameterInfo> variableParameters, boolean autoComplete, MethodInfo methodInfo, boolean enabled) {
        this.type = type;
        this.name = name;
        this.timeout = timeout;
        this.maxJobsActive = maxJobsActive;
        this.requestTimeout = requestTimeout;
        this.pollInterval = pollInterval;
        this.autoComplete = autoComplete;
        this.methodInfo = methodInfo;
        this.enabled = enabled;
    }

    public String getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Long getTimeout() {
        return this.timeout;
    }

    public Integer getMaxJobsActive() {
        return this.maxJobsActive;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public Long getPollInterval() {
        return this.pollInterval;
    }

    public String[] getFetchVariables() {
        return this.fetchVariables;
    }

    public Boolean getAutoComplete() {
        return this.autoComplete;
    }

    public MethodInfo getMethodInfo() {
        return this.methodInfo;
    }

    @Override
    public MethodInfo getBeanInfo() {
        return this.getMethodInfo();
    }

    public Boolean getEnabled() {
        return this.enabled;
    }

    public ZeebeWorkerValue setEnabled(Boolean enabled) {
        this.enabled = enabled;
        return this;
    }

    public ZeebeWorkerValue setType(String type) {
        this.type = type;
        if (this.name == null) {
            this.setName(type);
        }
        return this;
    }

    public ZeebeWorkerValue setName(String name) {
        this.name = name;
        return this;
    }

    public ZeebeWorkerValue setTimeout(Long timeout) {
        this.timeout = timeout;
        return this;
    }

    public ZeebeWorkerValue setMaxJobsActive(Integer maxJobsActive) {
        this.maxJobsActive = maxJobsActive;
        return this;
    }

    public ZeebeWorkerValue setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public ZeebeWorkerValue setPollInterval(Long pollInterval) {
        this.pollInterval = pollInterval;
        return this;
    }

    public ZeebeWorkerValue setAutoComplete(Boolean autoComplete) {
        this.autoComplete = autoComplete;
        return this;
    }

    public ZeebeWorkerValue setFetchVariables(String[] fetchVariables) {
        this.fetchVariables = fetchVariables;
        return this;
    }

    public ZeebeWorkerValue setMethodInfo(MethodInfo methodInfo) {
        this.methodInfo = methodInfo;
        return this;
    }

    public ZeebeWorkerValue merge(ZeebeWorkerValue other) {
        try {
            BEAN_UTILS_BEAN.copyProperties(this, other);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        return this;
    }

    public String toString() {
        return "ZeebeWorkerValue{type='" + this.type + "', name='" + this.name + "', timeout=" + this.timeout + ", maxJobsActive=" + this.maxJobsActive + ", requestTimeout=" + this.requestTimeout + ", pollInterval=" + this.pollInterval + ", autoComplete=" + this.autoComplete + ", fetchVariables=" + Arrays.toString(this.fetchVariables) + ", enabled=" + this.enabled + ", methodInfo=" + String.valueOf(this.methodInfo) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ZeebeWorkerValue that = (ZeebeWorkerValue)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.timeout, that.timeout) && Objects.equals(this.maxJobsActive, that.maxJobsActive) && Objects.equals(this.requestTimeout, that.requestTimeout) && Objects.equals(this.pollInterval, that.pollInterval) && Objects.equals(this.autoComplete, that.autoComplete) && Arrays.equals(this.fetchVariables, that.fetchVariables) && Objects.equals(this.enabled, that.enabled) && Objects.equals(this.methodInfo, that.methodInfo);
    }

    public int hashCode() {
        int result = Objects.hash(this.type, this.name, this.timeout, this.maxJobsActive, this.requestTimeout, this.pollInterval, this.autoComplete, this.enabled, this.methodInfo);
        result = 31 * result + Arrays.hashCode(this.fetchVariables);
        return result;
    }

    public ZeebeWorkerValue initializeName(String name, MethodInfo methodInfo, String defaultJobWorkerName) {
        this.name = name != null && name.length() > 0 ? name : (null != defaultJobWorkerName ? defaultJobWorkerName : methodInfo.getBeanName() + "#" + methodInfo.getMethodName());
        return this;
    }

    public ZeebeWorkerValue initializeFetchVariables(boolean forceFetchAllVariables, String[] fetchVariables, MethodInfo methodInfo) {
        if (forceFetchAllVariables) {
            this.setFetchVariables(new String[0]);
        } else {
            HashSet<String> variables = new HashSet<String>();
            variables.addAll(Arrays.asList(fetchVariables));
            variables.addAll(this.readZeebeVariableParameters(methodInfo).stream().map(ParameterInfo::getParameterName).collect(Collectors.toList()));
            this.setFetchVariables(variables.toArray(new String[0]));
        }
        return this;
    }

    private List<ParameterInfo> readZeebeVariableParameters(MethodInfo methodInfo) {
        List<ParameterInfo> result = methodInfo.getParametersFilteredByAnnotation(Variable.class);
        result.addAll(methodInfo.getParametersFilteredByAnnotation(ZeebeVariable.class));
        return result;
    }

    public ZeebeWorkerValue initializeJobType(String jobType, MethodInfo methodInfo, String defaultWorkerType) {
        if (jobType != null && jobType.length() > 0) {
            this.setType(jobType);
        } else if (defaultWorkerType != null) {
            this.setType(defaultWorkerType);
        } else {
            this.setType(methodInfo.getMethodName());
        }
        return this;
    }
}

