/*
 * Decompiled with CFR 0.152.
 */
package io.camunda.zeebe.spring.client.jobhandling.parameter;

import io.camunda.zeebe.client.api.JsonMapper;
import io.camunda.zeebe.client.api.response.ActivatedJob;
import io.camunda.zeebe.client.api.worker.JobClient;
import io.camunda.zeebe.spring.client.annotation.CustomHeaders;
import io.camunda.zeebe.spring.client.annotation.Variable;
import io.camunda.zeebe.spring.client.annotation.VariablesAsType;
import io.camunda.zeebe.spring.client.annotation.ZeebeCustomHeaders;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariable;
import io.camunda.zeebe.spring.client.annotation.ZeebeVariablesAsType;
import io.camunda.zeebe.spring.client.bean.ParameterInfo;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ActivatedJobParameterResolver;
import io.camunda.zeebe.spring.client.jobhandling.parameter.CustomHeadersResolver;
import io.camunda.zeebe.spring.client.jobhandling.parameter.JobClientParameterResolver;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolver;
import io.camunda.zeebe.spring.client.jobhandling.parameter.ParameterResolverStrategy;
import io.camunda.zeebe.spring.client.jobhandling.parameter.VariableResolver;
import io.camunda.zeebe.spring.client.jobhandling.parameter.VariablesAsTypeResolver;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultParameterResolverStrategy
implements ParameterResolverStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DefaultParameterResolverStrategy.class);
    protected final JsonMapper jsonMapper;

    public DefaultParameterResolverStrategy(JsonMapper jsonMapper) {
        this.jsonMapper = jsonMapper;
    }

    @Override
    public ParameterResolver createResolver(ParameterInfo parameterInfo) {
        Class<?> parameterType = parameterInfo.getParameterInfo().getType();
        if (JobClient.class.isAssignableFrom(parameterType)) {
            return new JobClientParameterResolver();
        }
        if (ActivatedJob.class.isAssignableFrom(parameterType)) {
            return new ActivatedJobParameterResolver();
        }
        if (this.isVariable(parameterInfo)) {
            String variableName = this.getVariableName(parameterInfo);
            return new VariableResolver(variableName, parameterType, this.jsonMapper);
        }
        if (this.isVariablesAsType(parameterInfo)) {
            return new VariablesAsTypeResolver(parameterType);
        }
        if (this.isCustomHeaders(parameterInfo)) {
            return new CustomHeadersResolver();
        }
        throw new IllegalStateException("Could not create parameter resolver for parameter " + String.valueOf(parameterInfo));
    }

    protected boolean isVariable(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(Variable.class) || parameterInfo.getParameterInfo().isAnnotationPresent(ZeebeVariable.class);
    }

    protected boolean isVariablesAsType(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(VariablesAsType.class) || parameterInfo.getParameterInfo().isAnnotationPresent(ZeebeVariablesAsType.class);
    }

    protected boolean isCustomHeaders(ParameterInfo parameterInfo) {
        return parameterInfo.getParameterInfo().isAnnotationPresent(CustomHeaders.class) || parameterInfo.getParameterInfo().isAnnotationPresent(ZeebeCustomHeaders.class);
    }

    protected String getVariableName(ParameterInfo param) {
        if (param.getParameterInfo().isAnnotationPresent(Variable.class)) {
            String nameFromAnnotation = param.getParameterInfo().getAnnotation(Variable.class).name();
            if (!Objects.equals(nameFromAnnotation, "$NULL$")) {
                LOG.trace("Extracting name {} from Variable.name", (Object)nameFromAnnotation);
                return nameFromAnnotation;
            }
            String valueFromAnnotation = param.getParameterInfo().getAnnotation(Variable.class).value();
            if (!Objects.equals(valueFromAnnotation, "$NULL$")) {
                LOG.trace("Extracting name {} from Variable.value", (Object)valueFromAnnotation);
                return valueFromAnnotation;
            }
        }
        LOG.trace("Extracting variable name from parameter name");
        return param.getParameterName();
    }
}

