/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import io.atomix.utils.net.Address;
import java.time.Duration;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public interface MessagingService {
    public Address address();

    public Collection<Address> bindingAddresses();

    default public CompletableFuture<Void> sendAsync(Address address, String type, byte[] payload) {
        return this.sendAsync(address, type, payload, true);
    }

    public CompletableFuture<Void> sendAsync(Address var1, String var2, byte[] var3, boolean var4);

    default public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload) {
        return this.sendAndReceive(address, type, payload, true);
    }

    public CompletableFuture<byte[]> sendAndReceive(Address var1, String var2, byte[] var3, boolean var4);

    default public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, Executor executor) {
        return this.sendAndReceive(address, type, payload, true, executor);
    }

    public CompletableFuture<byte[]> sendAndReceive(Address var1, String var2, byte[] var3, boolean var4, Executor var5);

    default public CompletableFuture<byte[]> sendAndReceive(Address address, String type, byte[] payload, Duration timeout) {
        return this.sendAndReceive(address, type, payload, true, timeout);
    }

    public CompletableFuture<byte[]> sendAndReceive(Address var1, String var2, byte[] var3, boolean var4, Duration var5);

    public CompletableFuture<byte[]> sendAndReceive(Address var1, String var2, byte[] var3, boolean var4, Duration var5, Executor var6);

    public void registerHandler(String var1, BiConsumer<Address, byte[]> var2, Executor var3);

    public void registerHandler(String var1, BiFunction<Address, byte[], byte[]> var2, Executor var3);

    public void registerHandler(String var1, BiFunction<Address, byte[], CompletableFuture<byte[]>> var2);

    public void unregisterHandler(String var1);

    public boolean isRunning();
}

