/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.ClusterMembershipService;
import io.atomix.cluster.MemberId;
import io.atomix.raft.ElectionTimer;
import io.atomix.raft.RaftCommitListener;
import io.atomix.raft.RaftCommittedEntryListener;
import io.atomix.raft.RaftException;
import io.atomix.raft.RaftRoleChangeListener;
import io.atomix.raft.RaftServer;
import io.atomix.raft.RaftThreadContextFactory;
import io.atomix.raft.SnapshotReplicationListener;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.cluster.impl.RaftClusterContext;
import io.atomix.raft.impl.PriorityElectionTimer;
import io.atomix.raft.impl.RandomizedElectionTimer;
import io.atomix.raft.impl.zeebe.LogCompactor;
import io.atomix.raft.metrics.RaftReplicationMetrics;
import io.atomix.raft.metrics.RaftRoleMetrics;
import io.atomix.raft.partition.RaftElectionConfig;
import io.atomix.raft.partition.RaftPartitionConfig;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.RaftServerProtocol;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.TransferRequest;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.roles.ActiveRole;
import io.atomix.raft.roles.CandidateRole;
import io.atomix.raft.roles.FollowerRole;
import io.atomix.raft.roles.InactiveRole;
import io.atomix.raft.roles.LeaderRole;
import io.atomix.raft.roles.PassiveRole;
import io.atomix.raft.roles.PromotableRole;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.storage.RaftStorage;
import io.atomix.raft.storage.StorageException;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.system.MetaStore;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.concurrent.ComposableFuture;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.Threads;
import io.atomix.utils.logging.ContextualLoggerFactory;
import io.atomix.utils.logging.LoggerContext;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStore;
import io.camunda.zeebe.util.exception.UnrecoverableException;
import io.camunda.zeebe.util.health.FailureListener;
import io.camunda.zeebe.util.health.HealthMonitorable;
import io.camunda.zeebe.util.health.HealthStatus;
import java.time.Duration;
import java.util.Objects;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.MDC;

public class RaftContext
implements AutoCloseable,
HealthMonitorable {
    protected final String name;
    protected final ThreadContext threadContext;
    protected final ClusterMembershipService membershipService;
    protected final RaftClusterContext cluster;
    protected final RaftServerProtocol protocol;
    protected final RaftStorage storage;
    private final Logger log;
    private final RaftElectionConfig electionConfig;
    private final Set<RaftRoleChangeListener> roleChangeListeners = new CopyOnWriteArraySet<RaftRoleChangeListener>();
    private final Set<Consumer<State>> stateChangeListeners = new CopyOnWriteArraySet<Consumer<State>>();
    private final Set<Consumer<RaftMember>> electionListeners = new CopyOnWriteArraySet<Consumer<RaftMember>>();
    private final Set<RaftCommitListener> commitListeners = new CopyOnWriteArraySet<RaftCommitListener>();
    private final Set<RaftCommittedEntryListener> committedEntryListeners = new CopyOnWriteArraySet<RaftCommittedEntryListener>();
    private final Set<SnapshotReplicationListener> snapshotReplicationListeners = new CopyOnWriteArraySet<SnapshotReplicationListener>();
    private final Set<FailureListener> failureListeners = new CopyOnWriteArraySet<FailureListener>();
    private final RaftRoleMetrics raftRoleMetrics;
    private final RaftReplicationMetrics replicationMetrics;
    private final MetaStore meta;
    private final RaftLog raftLog;
    private final ReceivableSnapshotStore persistedSnapshotStore;
    private final LogCompactor logCompactor;
    private volatile State state = State.ACTIVE;
    private RaftRole role = new InactiveRole(this);
    private volatile MemberId leader;
    private volatile long term;
    private MemberId lastVotedFor;
    private long commitIndex;
    private volatile long firstCommitIndex;
    private volatile boolean started;
    private EntryValidator entryValidator;
    private final Random random;
    private PersistedSnapshot currentSnapshot;
    private volatile HealthStatus health = HealthStatus.HEALTHY;
    private boolean ongoingTransition = false;
    private long lastHeartbeat;
    private final RaftPartitionConfig partitionConfig;
    private final int partitionId;

    public RaftContext(String name, int partitionId, MemberId localMemberId, ClusterMembershipService membershipService, RaftServerProtocol protocol, RaftStorage storage, RaftThreadContextFactory threadContextFactory, Supplier<Random> randomFactory, RaftElectionConfig electionConfig, RaftPartitionConfig partitionConfig) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (Object)"name cannot be null");
        this.membershipService = (ClusterMembershipService)Preconditions.checkNotNull((Object)membershipService, (Object)"membershipService cannot be null");
        this.protocol = (RaftServerProtocol)Preconditions.checkNotNull((Object)protocol, (Object)"protocol cannot be null");
        this.storage = (RaftStorage)Preconditions.checkNotNull((Object)storage, (Object)"storage cannot be null");
        this.random = randomFactory.get();
        this.partitionId = partitionId;
        this.raftRoleMetrics = new RaftRoleMetrics(name);
        this.log = ContextualLoggerFactory.getLogger(this.getClass(), (LoggerContext)LoggerContext.builder(RaftServer.class).addValue((Object)name).build());
        this.electionConfig = electionConfig;
        if (electionConfig.isPriorityElectionEnabled()) {
            this.log.debug("Priority election is enabled with target priority {} and node priority {}", (Object)electionConfig.getInitialTargetPriority(), (Object)electionConfig.getNodePriority());
        }
        if (!storage.lock((String)((Object)localMemberId.id()))) {
            throw new StorageException("Failed to acquire storage lock; ensure each Raft server is configured with a distinct storage directory");
        }
        String baseThreadName = String.format("raft-server-%s-%s", localMemberId.id(), name);
        this.threadContext = threadContextFactory.createContext(Threads.namedThreads((String)baseThreadName, (Logger)this.log), this::onUncaughtException);
        this.threadContext.execute(() -> MDC.put((String)"partitionId", (String)Integer.toString(partitionId)));
        this.meta = storage.openMetaStore();
        this.term = this.meta.loadTerm();
        this.lastVotedFor = this.meta.loadVote();
        this.raftLog = storage.openLog();
        this.persistedSnapshotStore = storage.getPersistedSnapshotStore();
        this.persistedSnapshotStore.addSnapshotListener(this::setSnapshot);
        this.persistedSnapshotStore.getLatestSnapshot().ifPresent(persistedSnapshot -> {
            this.currentSnapshot = persistedSnapshot;
        });
        this.verifySnapshotLogConsistent();
        this.logCompactor = new LogCompactor(this);
        this.partitionConfig = partitionConfig;
        this.cluster = new RaftClusterContext(localMemberId, this);
        this.replicationMetrics = new RaftReplicationMetrics(name);
        this.replicationMetrics.setAppendIndex(this.raftLog.getLastIndex());
        this.lastHeartbeat = System.currentTimeMillis();
        this.registerHandlers(protocol);
        this.started = true;
    }

    private void verifySnapshotLogConsistent() {
        long currentSnapshotIndex = this.getCurrentSnapshotIndex();
        if (currentSnapshotIndex <= 0L && this.raftLog.getFirstIndex() != 1L || currentSnapshotIndex > 0L && this.currentSnapshot.getIndex() + 1L < this.raftLog.getFirstIndex()) {
            throw new IllegalStateException(String.format("Expected to find a snapshot at index >= log's first index %d, but found snapshot %d. A previous snapshot is most likely corrupted.", this.raftLog.getFirstIndex(), currentSnapshotIndex));
        }
    }

    private void setSnapshot(PersistedSnapshot persistedSnapshot) {
        this.threadContext.execute(() -> {
            this.currentSnapshot = persistedSnapshot;
        });
    }

    private void onUncaughtException(Throwable error) {
        this.log.error("An uncaught exception occurred, transition to inactive role", error);
        try {
            this.transition(RaftServer.Role.INACTIVE);
        }
        catch (Exception e) {
            this.log.error("An error occurred when transitioning to inactive, closing the raft context", (Throwable)e);
            this.close();
        }
        this.notifyFailureListeners(error);
    }

    private void notifyFailureListeners(Throwable error) {
        try {
            if (error instanceof UnrecoverableException) {
                this.health = HealthStatus.DEAD;
                this.failureListeners.forEach(FailureListener::onUnrecoverableFailure);
            } else {
                this.health = HealthStatus.UNHEALTHY;
                this.failureListeners.forEach(FailureListener::onFailure);
            }
        }
        catch (Exception e) {
            this.log.error("Could not notify failure listeners", (Throwable)e);
        }
    }

    private void registerHandlers(RaftServerProtocol protocol) {
        protocol.registerConfigureHandler(request -> this.runOnContext(() -> this.role.onConfigure((ConfigureRequest)request)));
        protocol.registerInstallHandler(request -> this.runOnContext(() -> this.role.onInstall((InstallRequest)request)));
        protocol.registerReconfigureHandler(request -> this.runOnContext(() -> this.role.onReconfigure((ReconfigureRequest)request)));
        protocol.registerTransferHandler(request -> this.runOnContext(() -> this.role.onTransfer((TransferRequest)request)));
        protocol.registerAppendHandler(request -> this.runOnContext(() -> this.role.onAppend((AppendRequest)request)));
        protocol.registerPollHandler(request -> this.runOnContext(() -> this.role.onPoll((PollRequest)request)));
        protocol.registerVoteHandler(request -> this.runOnContext(() -> this.role.onVote((VoteRequest)request)));
    }

    private <R extends RaftResponse> CompletableFuture<R> runOnContext(Supplier<CompletableFuture<R>> function) {
        CompletableFuture future = new CompletableFuture();
        this.threadContext.execute(() -> ((CompletableFuture)function.get()).whenComplete((response, error) -> {
            if (error == null) {
                future.complete(response);
            } else {
                future.completeExceptionally((Throwable)error);
            }
        }));
        return future;
    }

    public int getMaxAppendBatchSize() {
        return this.partitionConfig.getMaxAppendBatchSize();
    }

    public int getMaxAppendsPerFollower() {
        return this.partitionConfig.getMaxAppendsPerFollower();
    }

    public void addRoleChangeListener(RaftRoleChangeListener listener) {
        this.threadContext.execute(() -> {
            this.roleChangeListeners.add(listener);
            if (!this.ongoingTransition) {
                listener.onNewRole(this.getRole(), this.getTerm());
            }
        });
    }

    public void removeRoleChangeListener(RaftRoleChangeListener listener) {
        this.roleChangeListeners.remove(listener);
    }

    public void awaitState(State state, final Consumer<State> listener) {
        if (this.state == state) {
            listener.accept(this.state);
        } else {
            this.addStateChangeListener(new Consumer<State>(){

                @Override
                public void accept(State state) {
                    listener.accept(state);
                    RaftContext.this.removeStateChangeListener(this);
                }
            });
        }
    }

    public void addStateChangeListener(Consumer<State> listener) {
        this.stateChangeListeners.add(listener);
    }

    public void removeStateChangeListener(Consumer<State> listener) {
        this.stateChangeListeners.remove(listener);
    }

    public void addCommitListener(RaftCommitListener commitListener) {
        this.commitListeners.add(commitListener);
    }

    public void removeCommitListener(RaftCommitListener commitListener) {
        this.commitListeners.remove(commitListener);
    }

    public void addCommittedEntryListener(RaftCommittedEntryListener raftCommittedEntryListener) {
        this.committedEntryListeners.add(raftCommittedEntryListener);
    }

    public void removeCommittedEntryListener(RaftCommittedEntryListener raftCommittedEntryListener) {
        this.committedEntryListeners.remove(raftCommittedEntryListener);
    }

    public void notifyCommitListeners(long lastCommitIndex) {
        this.commitListeners.forEach(listener -> listener.onCommit(lastCommitIndex));
    }

    public void notifyCommitListeners(IndexedRaftLogEntry committedEntry) {
        this.commitListeners.forEach(listener -> listener.onCommit(committedEntry.index()));
        this.committedEntryListeners.forEach(listener -> listener.onCommit(committedEntry));
    }

    public long setCommitIndex(long commitIndex) {
        Preconditions.checkArgument((commitIndex >= 0L ? 1 : 0) != 0, (Object)"commitIndex must be positive");
        long previousCommitIndex = this.commitIndex;
        if (commitIndex > previousCommitIndex) {
            long configurationIndex;
            this.commitIndex = commitIndex;
            this.raftLog.setCommitIndex(Math.min(commitIndex, this.raftLog.getLastIndex()));
            if (this.raftLog.shouldFlushExplicitly() && this.isLeader()) {
                this.raftLog.flush();
                this.setLastWrittenIndex(commitIndex);
            }
            if ((configurationIndex = this.cluster.getConfiguration().index()) > previousCommitIndex && configurationIndex <= commitIndex) {
                this.cluster.commit();
            }
            this.setFirstCommitIndex(commitIndex);
            if (this.state == State.ACTIVE && commitIndex >= this.firstCommitIndex) {
                this.state = State.READY;
                this.stateChangeListeners.forEach(l -> l.accept(this.state));
            }
            this.replicationMetrics.setCommitIndex(commitIndex);
        }
        return previousCommitIndex;
    }

    public void addSnapshotReplicationListener(SnapshotReplicationListener snapshotReplicationListener) {
        this.snapshotReplicationListeners.add(snapshotReplicationListener);
    }

    public void removeSnapshotReplicationListener(SnapshotReplicationListener snapshotReplicationListener) {
        this.snapshotReplicationListeners.remove(snapshotReplicationListener);
    }

    public void notifySnapshotReplicationStarted() {
        this.snapshotReplicationListeners.forEach(SnapshotReplicationListener::onSnapshotReplicationStarted);
    }

    public void notifySnapshotReplicationCompleted() {
        this.snapshotReplicationListeners.forEach(l -> l.onSnapshotReplicationCompleted(this.term));
    }

    public CompletableFuture<Void> compact() {
        ComposableFuture future = new ComposableFuture();
        this.threadContext.execute(() -> this.logCompactor.compact().whenComplete((BiConsumer)future));
        return future;
    }

    public CompletableFuture<Void> anoint() {
        if (this.role.role() == RaftServer.Role.LEADER) {
            return CompletableFuture.completedFuture(null);
        }
        final CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.threadContext.execute(() -> {
            Consumer<RaftMember> electionListener = new Consumer<RaftMember>(){

                @Override
                public void accept(RaftMember member) {
                    if (member.memberId().equals(RaftContext.this.cluster.getLocalMember().memberId())) {
                        future.complete(null);
                    } else {
                        future.completeExceptionally(new RaftException.ProtocolException("Failed to transfer leadership", new Object[0]));
                    }
                    RaftContext.this.removeLeaderElectionListener(this);
                }
            };
            this.addLeaderElectionListener(electionListener);
            RaftMember member = this.getCluster().getLocalMember();
            DefaultRaftMember leader = this.getLeader();
            if (leader != null) {
                this.protocol.transfer(leader.memberId(), TransferRequest.builder().withMember(member.memberId()).build()).whenCompleteAsync((response, error) -> {
                    if (error != null) {
                        future.completeExceptionally((Throwable)error);
                    } else if (response.status() == RaftResponse.Status.ERROR) {
                        future.completeExceptionally((Throwable)((Object)response.error().createException()));
                    } else {
                        this.transition(RaftServer.Role.CANDIDATE);
                    }
                }, (Executor)this.threadContext);
            } else {
                this.transition(RaftServer.Role.CANDIDATE);
            }
        });
        return future;
    }

    public void addLeaderElectionListener(Consumer<RaftMember> listener) {
        this.electionListeners.add(listener);
    }

    public void removeLeaderElectionListener(Consumer<RaftMember> listener) {
        this.electionListeners.remove(listener);
    }

    public RaftClusterContext getCluster() {
        return this.cluster;
    }

    public DefaultRaftMember getLeader() {
        MemberId leader = this.leader;
        return leader != null ? this.cluster.getMember(leader) : null;
    }

    public void transition(RaftServer.Role role) {
        this.checkThread();
        Preconditions.checkNotNull((Object)((Object)role));
        if (this.role.role() == role) {
            return;
        }
        this.log.info("Transitioning to {}", (Object)role);
        this.startTransition();
        try {
            this.role.stop().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to close Raft state", e);
        }
        try {
            this.role = this.createRole(role);
            this.role.start().get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize Raft state", e);
        }
        if (!this.role.role().active() && role.active()) {
            this.health = HealthStatus.HEALTHY;
            this.failureListeners.forEach(FailureListener::onRecovered);
        }
        if (this.role.role() == role) {
            if (this.role.role() == RaftServer.Role.LEADER) {
                LeaderRole leaderRole = (LeaderRole)this.role;
                leaderRole.onInitialEntriesCommitted(() -> {
                    if (this.role == leaderRole) {
                        this.notifyRoleChangeListeners();
                        this.completeTransition();
                    }
                });
            } else {
                this.notifyRoleChangeListeners();
                this.completeTransition();
            }
        }
    }

    public HealthStatus getHealthStatus() {
        return this.health;
    }

    public void addFailureListener(FailureListener listener) {
        this.failureListeners.add(listener);
    }

    public void removeFailureListener(FailureListener listener) {
        this.failureListeners.remove(listener);
    }

    private void startTransition() {
        this.ongoingTransition = true;
    }

    private void completeTransition() {
        this.ongoingTransition = false;
    }

    private void notifyRoleChangeListeners() {
        try {
            this.roleChangeListeners.forEach(l -> l.onNewRole(this.role.role(), this.getTerm()));
        }
        catch (Exception exception) {
            this.log.error("Unexpected error on calling role change listeners.", (Throwable)exception);
        }
    }

    public void checkThread() {
        this.threadContext.checkThread();
    }

    private RaftRole createRole(RaftServer.Role role) {
        switch (role) {
            case INACTIVE: {
                return new InactiveRole(this);
            }
            case PASSIVE: {
                return new PassiveRole(this);
            }
            case PROMOTABLE: {
                return new PromotableRole(this);
            }
            case FOLLOWER: {
                this.raftRoleMetrics.becomingFollower();
                return new FollowerRole(this, this::createElectionTimer);
            }
            case CANDIDATE: {
                this.raftRoleMetrics.becomingCandidate();
                return new CandidateRole(this);
            }
            case LEADER: {
                this.raftRoleMetrics.becomingLeader();
                return new LeaderRole(this);
            }
        }
        throw new AssertionError();
    }

    private ElectionTimer createElectionTimer(Runnable triggerElection, Logger log) {
        if (this.electionConfig.isPriorityElectionEnabled()) {
            return new PriorityElectionTimer(this.partitionConfig.getElectionTimeout(), this.threadContext, triggerElection, log, this.electionConfig.getInitialTargetPriority(), this.electionConfig.getNodePriority());
        }
        return new RandomizedElectionTimer(this.partitionConfig.getElectionTimeout(), this.threadContext, this.random, triggerElection, log);
    }

    public void transition(RaftMember.Type type) {
        switch (type) {
            case ACTIVE: {
                if (this.role instanceof ActiveRole) break;
                this.transition(RaftServer.Role.FOLLOWER);
                break;
            }
            case PROMOTABLE: {
                if (this.role.role() == RaftServer.Role.PROMOTABLE) break;
                this.transition(RaftServer.Role.PROMOTABLE);
                break;
            }
            case PASSIVE: {
                if (this.role.role() == RaftServer.Role.PASSIVE) break;
                this.transition(RaftServer.Role.PASSIVE);
                break;
            }
            default: {
                if (this.role.role() == RaftServer.Role.INACTIVE) break;
                this.transition(RaftServer.Role.INACTIVE);
            }
        }
    }

    @Override
    public void close() {
        this.started = false;
        this.unregisterHandlers(this.protocol);
        this.logCompactor.close();
        try {
            this.raftLog.close();
        }
        catch (Exception e) {
            this.log.error("Failed to close raft log", (Throwable)e);
        }
        try {
            this.meta.close();
        }
        catch (Exception e) {
            this.log.error("Failed to close metastore", (Throwable)e);
        }
        try {
            this.persistedSnapshotStore.close();
        }
        catch (Exception e) {
            this.log.error("Failed to close snapshot store", (Throwable)e);
        }
        this.threadContext.close();
    }

    private void unregisterHandlers(RaftServerProtocol protocol) {
        protocol.unregisterConfigureHandler();
        protocol.unregisterInstallHandler();
        protocol.unregisterReconfigureHandler();
        protocol.unregisterTransferHandler();
        protocol.unregisterAppendHandler();
        protocol.unregisterPollHandler();
        protocol.unregisterVoteHandler();
    }

    public String toString() {
        return this.getClass().getCanonicalName();
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public Duration getElectionTimeout() {
        return this.partitionConfig.getElectionTimeout();
    }

    public long getFirstCommitIndex() {
        return this.firstCommitIndex;
    }

    public void setFirstCommitIndex(long firstCommitIndex) {
        if (this.firstCommitIndex == 0L) {
            this.firstCommitIndex = firstCommitIndex;
            this.log.info("Setting firstCommitIndex to {}. RaftServer is ready only after it has committed events upto this index", (Object)firstCommitIndex);
        }
    }

    public Duration getHeartbeatInterval() {
        return this.partitionConfig.getHeartbeatInterval();
    }

    public EntryValidator getEntryValidator() {
        return this.entryValidator;
    }

    public void setEntryValidator(EntryValidator validator) {
        this.entryValidator = validator;
    }

    public MemberId getLastVotedFor() {
        return this.lastVotedFor;
    }

    public void setLastVotedFor(MemberId candidate) {
        Preconditions.checkState((this.lastVotedFor == null || candidate == null ? 1 : 0) != 0, (Object)"Already voted for another candidate");
        DefaultRaftMember member = this.cluster.getMember(candidate);
        Preconditions.checkState((member != null ? 1 : 0) != 0, (String)"Unknown candidate: %d", (Object)candidate);
        this.lastVotedFor = candidate;
        this.meta.storeVote(this.lastVotedFor);
        if (candidate != null) {
            this.log.debug("Voted for {}", (Object)member.memberId());
        } else {
            this.log.trace("Reset last voted for");
        }
    }

    public RaftLog getLog() {
        return this.raftLog;
    }

    public ClusterMembershipService getMembershipService() {
        return this.membershipService;
    }

    public MetaStore getMetaStore() {
        return this.meta;
    }

    public String getName() {
        return this.name;
    }

    public RaftServerProtocol getProtocol() {
        return this.protocol;
    }

    public RaftRole getRaftRole() {
        return this.role;
    }

    public RaftRoleMetrics getRaftRoleMetrics() {
        return this.raftRoleMetrics;
    }

    public RaftServer.Role getRole() {
        return this.role.role();
    }

    public LogCompactor getLogCompactor() {
        return this.logCompactor;
    }

    public ReceivableSnapshotStore getPersistedSnapshotStore() {
        return this.persistedSnapshotStore;
    }

    public State getState() {
        return this.state;
    }

    public RaftStorage getStorage() {
        return this.storage;
    }

    public long getTerm() {
        return this.term;
    }

    public void setTerm(long term) {
        if (term > this.term) {
            this.term = term;
            this.leader = null;
            this.lastVotedFor = null;
            this.meta.storeTerm(this.term);
            this.meta.storeVote(this.lastVotedFor);
            this.log.debug("Set term {}", (Object)term);
        }
    }

    public void setLastWrittenIndex(long index) {
        this.meta.storeLastWrittenIndex(index);
    }

    public ThreadContext getThreadContext() {
        return this.threadContext;
    }

    public boolean isLeader() {
        MemberId leader = this.leader;
        return leader != null && leader.equals(this.cluster.getLocalMember().memberId());
    }

    public void setLeader(MemberId leader) {
        if (!Objects.equals(this.leader, leader)) {
            if (leader == null) {
                this.leader = null;
            } else {
                DefaultRaftMember member = this.cluster.getMember(leader);
                if (member != null) {
                    this.leader = leader;
                    this.log.info("Found leader {}", (Object)member.memberId());
                    this.electionListeners.forEach(l -> l.accept(member));
                }
            }
            this.log.trace("Set leader {}", (Object)this.leader);
        }
    }

    public PersistedSnapshot getCurrentSnapshot() {
        return this.currentSnapshot;
    }

    public long getCurrentSnapshotIndex() {
        return this.currentSnapshot != null ? this.currentSnapshot.getIndex() : 0L;
    }

    public boolean isRunning() {
        return this.started;
    }

    public RaftReplicationMetrics getReplicationMetrics() {
        return this.replicationMetrics;
    }

    public Random getRandom() {
        return this.random;
    }

    public long getLastHeartbeat() {
        return this.lastHeartbeat;
    }

    public void setLastHeartbeat(long lastHeartbeat) {
        this.lastHeartbeat = lastHeartbeat;
    }

    public void resetLastHeartbeat() {
        this.setLastHeartbeat(System.currentTimeMillis());
    }

    public int getMinStepDownFailureCount() {
        return this.partitionConfig.getMinStepDownFailureCount();
    }

    public Duration getMaxQuorumResponseTimeout() {
        return this.partitionConfig.getMaxQuorumResponseTimeout();
    }

    public int getPartitionId() {
        return this.partitionId;
    }

    public static enum State {
        ACTIVE,
        READY;

    }
}

