/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.impl;

import io.atomix.cluster.BootstrapService;
import io.atomix.cluster.Node;
import io.atomix.cluster.discovery.ManagedNodeDiscoveryService;
import io.atomix.cluster.discovery.NodeDiscoveryEvent;
import io.atomix.cluster.discovery.NodeDiscoveryEventListener;
import io.atomix.cluster.discovery.NodeDiscoveryProvider;
import io.atomix.cluster.discovery.NodeDiscoveryService;
import io.atomix.utils.event.AbstractListenerManager;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicBoolean;

public class DefaultNodeDiscoveryService
extends AbstractListenerManager<NodeDiscoveryEvent, NodeDiscoveryEventListener>
implements ManagedNodeDiscoveryService {
    private final BootstrapService bootstrapService;
    private final Node localNode;
    private final NodeDiscoveryProvider provider;
    private final AtomicBoolean started = new AtomicBoolean();
    private final NodeDiscoveryEventListener discoveryEventListener = x$0 -> this.post(x$0);

    public DefaultNodeDiscoveryService(BootstrapService bootstrapService, Node localNode, NodeDiscoveryProvider provider) {
        this.bootstrapService = bootstrapService;
        this.localNode = localNode;
        this.provider = provider;
    }

    @Override
    public Set<Node> getNodes() {
        return this.provider.getNodes();
    }

    public CompletableFuture<NodeDiscoveryService> start() {
        if (this.started.compareAndSet(false, true)) {
            this.provider.addListener(this.discoveryEventListener);
            Node node = Node.builder().withId((String)((Object)this.localNode.id().id())).withAddress(this.localNode.address()).build();
            return this.provider.join(this.bootstrapService, node).thenApply(v -> this);
        }
        return CompletableFuture.completedFuture(this);
    }

    public boolean isRunning() {
        return this.started.get();
    }

    public CompletableFuture<Void> stop() {
        if (this.started.compareAndSet(true, false)) {
            return this.provider.leave(this.localNode).thenRun(() -> this.provider.removeListener(this.discoveryEventListener));
        }
        return CompletableFuture.completedFuture(null);
    }
}

