/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.raft.RaftException;
import io.atomix.raft.RaftServer;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.RaftMemberContext;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.RaftRequest;
import io.atomix.raft.roles.AbstractAppender;
import io.atomix.raft.roles.LeaderRole;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;

final class LeaderAppender
extends AbstractAppender {
    private static final int MIN_BACKOFF_FAILURE_COUNT = 5;
    private final long leaderTime;
    private final long leaderIndex;
    private final long electionTimeout;
    private final long heartbeatInterval;
    private final Map<Long, CompletableFuture<Long>> appendFutures = new HashMap<Long, CompletableFuture<Long>>();
    private final List<TimestampedFuture<Long>> heartbeatFutures = new ArrayList<TimestampedFuture<Long>>();
    private final long heartbeatTime;
    private final int minStepDownFailureCount;
    private final long maxQuorumResponseTimeout;

    LeaderAppender(LeaderRole leader) {
        super(leader.raft);
        this.leaderTime = System.currentTimeMillis();
        this.leaderIndex = this.raft.getLog().isEmpty() ? this.raft.getLog().getFirstIndex() : this.raft.getLog().getLastIndex() + 1L;
        this.heartbeatTime = this.leaderTime;
        this.electionTimeout = this.raft.getElectionTimeout().toMillis();
        this.heartbeatInterval = this.raft.getHeartbeatInterval().toMillis();
        this.minStepDownFailureCount = this.raft.getMinStepDownFailureCount();
        this.maxQuorumResponseTimeout = this.raft.getMaxQuorumResponseTimeout().isZero() ? this.electionTimeout * 2L : this.raft.getMaxQuorumResponseTimeout().toMillis();
    }

    public CompletableFuture<Long> appendEntries(long index) {
        this.raft.checkThread();
        if (index == 0L) {
            return this.appendEntries();
        }
        if (index <= this.raft.getCommitIndex()) {
            return CompletableFuture.completedFuture(index);
        }
        if (this.raft.getCluster().getActiveMemberStates().isEmpty()) {
            long previousCommitIndex = this.raft.getCommitIndex();
            this.raft.setCommitIndex(index);
            this.completeCommits(previousCommitIndex, index);
            return CompletableFuture.completedFuture(index);
        }
        return this.appendFutures.computeIfAbsent(index, i -> {
            for (RaftMemberContext member : this.raft.getCluster().getActiveMemberStates()) {
                this.appendEntries(member);
            }
            return new CompletableFuture();
        });
    }

    public CompletableFuture<Long> appendEntries() {
        this.raft.checkThread();
        if (this.raft.getCluster().getRemoteMemberStates().isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        TimestampedFuture<Long> future = new TimestampedFuture<Long>();
        this.heartbeatFutures.add(future);
        for (RaftMemberContext member : this.raft.getCluster().getRemoteMemberStates()) {
            this.appendEntries(member);
        }
        return future;
    }

    private void completeCommits(long previousCommitIndex, long commitIndex) {
        for (long i = previousCommitIndex + 1L; i <= commitIndex; ++i) {
            CompletableFuture<Long> future = this.appendFutures.remove(i);
            if (future == null) continue;
            future.complete(i);
        }
    }

    @Override
    protected void handleAppendResponseFailure(RaftMemberContext member, AppendRequest request, Throwable error) {
        this.failHeartbeat();
        super.handleAppendResponseFailure(member, request, error);
    }

    @Override
    protected void failAttempt(RaftMemberContext member, RaftRequest request, Throwable error) {
        super.failAttempt(member, request, error);
        this.failHeartbeat();
        long quorumResponseTime = System.currentTimeMillis() - Math.max(this.computeResponseTime(), this.leaderTime);
        if (member.getFailureCount() >= this.minStepDownFailureCount && quorumResponseTime > this.maxQuorumResponseTimeout) {
            this.log.warn("Suspected network partition after {} failures from {} over a period of time {} > {}, stepping down", new Object[]{member.getFailureCount(), member.getMember().memberId(), quorumResponseTime, this.maxQuorumResponseTimeout});
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        }
    }

    @Override
    protected void handleAppendResponse(RaftMemberContext member, AppendRequest request, AppendResponse response, long timestamp) {
        super.handleAppendResponse(member, request, response, timestamp);
        this.recordHeartbeat(member, timestamp);
    }

    @Override
    protected void handleAppendResponseOk(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        this.succeedAttempt(member);
        if (response.succeeded()) {
            member.appendSucceeded();
            this.updateMatchIndex(member, response);
            this.commitEntries();
            if (this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        } else if (response.term() > this.raft.getTerm()) {
            this.log.info("Received successful append response higher term ({} > {}) from {}, implying there is a new leader - transitioning to follower", new Object[]{response.term(), this.raft.getTerm(), member.getMember()});
            this.raft.setTerm(response.term());
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        } else {
            member.appendFailed();
            this.resetMatchIndex(member, response);
            this.resetNextIndex(member, response);
            this.resetSnapshotIndex(member, response);
            if (this.hasMoreEntries(member)) {
                this.appendEntries(member);
            }
        }
    }

    @Override
    protected void appendEntries(RaftMemberContext member) {
        if (!this.open) {
            return;
        }
        if (member.getFailureCount() >= 5) {
            this.sendAppendRequest(member, this.buildAppendEmptyRequest(member));
        } else if (member.getConfigTerm() < this.raft.getTerm() || member.getConfigIndex() < this.raft.getCluster().getConfiguration().index()) {
            if (member.canConfigure()) {
                this.sendConfigureRequest(member, this.buildConfigureRequest());
            } else if (member.canHeartbeat()) {
                this.sendAppendRequest(member, this.buildAppendEmptyRequest(member));
            }
        } else if (member.getMember().getType() == RaftMember.Type.ACTIVE || member.getMember().getType() == RaftMember.Type.PROMOTABLE || member.getMember().getType() == RaftMember.Type.PASSIVE) {
            this.tryToReplicate(member);
        } else if (member.canAppend()) {
            this.sendAppendRequest(member, this.buildAppendRequest(member, -1L));
        }
    }

    @Override
    protected boolean hasMoreEntries(RaftMemberContext member) {
        return member.hasNextEntry();
    }

    @Override
    protected void handleAppendResponseError(RaftMemberContext member, AppendRequest request, AppendResponse response) {
        if (response.term() > this.raft.getTerm()) {
            this.log.info("Received error append response with higher term ({} > {}) from {}, implying there is a new leader, transitioning to follower", new Object[]{response.term(), this.raft.getTerm(), member.getMember()});
            this.raft.setTerm(response.term());
            this.raft.setLeader(null);
            this.raft.transition(RaftServer.Role.FOLLOWER);
        } else {
            super.handleAppendResponseError(member, request, response);
        }
    }

    @Override
    protected void handleConfigureResponse(RaftMemberContext member, ConfigureRequest request, ConfigureResponse response, long timestamp) {
        super.handleConfigureResponse(member, request, response, timestamp);
        this.recordHeartbeat(member, timestamp);
    }

    @Override
    protected void handleInstallResponse(RaftMemberContext member, InstallRequest request, InstallResponse response, long timestamp) {
        super.handleInstallResponse(member, request, response, timestamp);
        this.recordHeartbeat(member, timestamp);
    }

    @Override
    public void close() {
        super.close();
        this.appendFutures.values().forEach(future -> future.completeExceptionally(new IllegalStateException("Inactive state")));
        this.heartbeatFutures.forEach(future -> future.completeExceptionally(new RaftException.ProtocolException("Failed to reach consensus", new Object[0])));
    }

    private void tryToReplicate(RaftMemberContext member) {
        if (this.shouldReplicateSnapshot(member)) {
            if (!member.canInstall()) {
                return;
            }
            this.replicateSnapshot(member);
        } else if (member.canAppend()) {
            this.replicateEvents(member);
        }
    }

    private boolean shouldReplicateSnapshot(RaftMemberContext member) {
        PersistedSnapshot persistedSnapshot = this.raft.getCurrentSnapshot();
        if (persistedSnapshot == null) {
            return false;
        }
        if (this.raft.getLog().getFirstIndex() > member.getCurrentIndex()) {
            return true;
        }
        long memberLag = persistedSnapshot.getIndex() - member.getCurrentIndex();
        return memberLag > (long)this.raft.getPreferSnapshotReplicationThreshold();
    }

    private void replicateSnapshot(RaftMemberContext member) {
        PersistedSnapshot persistedSnapshot = this.raft.getCurrentSnapshot();
        this.log.debug("Replicating snapshot {} to {}", (Object)persistedSnapshot.getIndex(), (Object)member.getMember().memberId());
        this.buildInstallRequest(member, persistedSnapshot).ifPresent(installRequest -> this.sendInstallRequest(member, (InstallRequest)installRequest));
    }

    private void replicateEvents(RaftMemberContext member) {
        this.sendAppendRequest(member, this.buildAppendRequest(member, -1L));
    }

    private void failHeartbeat() {
        this.raft.checkThread();
        long currentTimestamp = System.currentTimeMillis();
        Iterator<TimestampedFuture<Long>> iterator = this.heartbeatFutures.iterator();
        while (iterator.hasNext()) {
            TimestampedFuture<Long> future = iterator.next();
            if (currentTimestamp - future.timestamp <= this.electionTimeout) continue;
            future.completeExceptionally(new RaftException.ProtocolException("Failed to reach consensus", new Object[0]));
            iterator.remove();
        }
    }

    private void recordHeartbeat(RaftMemberContext member, long timestamp) {
        this.raft.checkThread();
        member.setHeartbeatTime(timestamp);
        member.setResponseTime(System.currentTimeMillis());
        long heartbeatTime = this.computeHeartbeatTime();
        long currentTimestamp = System.currentTimeMillis();
        Iterator<TimestampedFuture<Long>> iterator = this.heartbeatFutures.iterator();
        while (iterator.hasNext()) {
            TimestampedFuture<Long> future = iterator.next();
            if (future.timestamp < heartbeatTime) {
                future.complete(null);
                iterator.remove();
                continue;
            }
            if (currentTimestamp - future.timestamp <= this.electionTimeout) break;
            future.completeExceptionally(new RaftException.ProtocolException("Failed to reach consensus", new Object[0]));
            iterator.remove();
        }
        if (!this.heartbeatFutures.isEmpty()) {
            this.sendHeartbeats();
        }
    }

    private long computeHeartbeatTime() {
        int quorumIndex = this.getQuorumIndex();
        if (quorumIndex >= 0) {
            return this.raft.getCluster().getActiveMemberStates((m1, m2) -> Long.compare(m2.getHeartbeatTime(), m1.getHeartbeatTime())).get(quorumIndex).getHeartbeatTime();
        }
        return System.currentTimeMillis();
    }

    private void sendHeartbeats() {
        for (RaftMemberContext member : this.raft.getCluster().getRemoteMemberStates()) {
            this.appendEntries(member);
        }
    }

    private void commitEntries() {
        this.raft.checkThread();
        List<RaftMemberContext> members = this.raft.getCluster().getActiveMemberStates((m1, m2) -> Long.compare(m2.getMatchIndex() != 0L ? m2.getMatchIndex() : 0L, m1.getMatchIndex() != 0L ? m1.getMatchIndex() : 0L));
        if (members.isEmpty()) {
            long previousCommitIndex;
            long commitIndex = this.raft.getLog().getLastIndex();
            if (commitIndex > (previousCommitIndex = this.raft.setCommitIndex(commitIndex))) {
                this.log.trace("Committed entries up to {}", (Object)commitIndex);
                this.completeCommits(previousCommitIndex, commitIndex);
            }
            return;
        }
        long commitIndex = members.get(this.getQuorumIndex()).getMatchIndex();
        long previousCommitIndex = this.raft.getCommitIndex();
        if (commitIndex > 0L && commitIndex > previousCommitIndex && this.leaderIndex > 0L && commitIndex >= this.leaderIndex) {
            this.log.trace("Committed entries up to {}", (Object)commitIndex);
            this.raft.setCommitIndex(commitIndex);
            this.completeCommits(previousCommitIndex, commitIndex);
        }
    }

    private long computeResponseTime() {
        int quorumIndex = this.getQuorumIndex();
        if (quorumIndex >= 0) {
            return this.raft.getCluster().getActiveMemberStates((m1, m2) -> Long.compare(m2.getResponseTime(), m1.getResponseTime())).get(quorumIndex).getResponseTime();
        }
        return System.currentTimeMillis();
    }

    private int getQuorumIndex() {
        return this.raft.getCluster().getQuorum() - 2;
    }

    public long getIndex() {
        return this.leaderIndex;
    }

    public long getTime() {
        return this.heartbeatTime;
    }

    private static class TimestampedFuture<T>
    extends CompletableFuture<T> {
        private final long timestamp;

        TimestampedFuture() {
            this(System.currentTimeMillis());
        }

        TimestampedFuture(long timestamp) {
            this.timestamp = timestamp;
        }
    }
}

