/* Generated SBE (Simple Binary Encoding) message codec. */
package io.atomix.raft.storage.serializer;

public enum MemberType
{
    INACTIVE((short)0),

    PASSIVE((short)1),

    PROMOTABLE((short)2),

    ACTIVE((short)3),

    /**
     * To be used to represent an unknown value from a later version.
     */
    SBE_UNKNOWN((short)255),

    /**
     * To be used to represent not present or null.
     */
    NULL_VAL((short)255);

    private final short value;

    MemberType(final short value)
    {
        this.value = value;
    }

    /**
     * The raw encoded value in the Java type representation.
     *
     * @return the raw value encoded.
     */
    public short value()
    {
        return value;
    }

    /**
     * Lookup the enum value representing the value.
     *
     * @param value encoded to be looked up.
     * @return the enum value representing the value.
     */
    public static MemberType get(final short value)
    {
        switch (value)
        {
            case 0: return INACTIVE;
            case 1: return PASSIVE;
            case 2: return PROMOTABLE;
            case 3: return ACTIVE;
            case 255: return NULL_VAL;
        }

        return SBE_UNKNOWN;
    }
}
