/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.protocol.AbstractRaftRequest;
import java.util.Collection;

public class ConfigureRequest
extends AbstractRaftRequest {
    private final long term;
    private final String leader;
    private final long index;
    private final long timestamp;
    private final Collection<RaftMember> members;

    public ConfigureRequest(long term, String leader, long index, long timestamp, Collection<RaftMember> members) {
        this.term = term;
        this.leader = leader;
        this.index = index;
        this.timestamp = timestamp;
        this.members = members;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return MemberId.from(this.leader);
    }

    public long index() {
        return this.index;
    }

    public long timestamp() {
        return this.timestamp;
    }

    public Collection<RaftMember> members() {
        return this.members;
    }

    public int hashCode() {
        int result = (int)(this.term ^ this.term >>> 32);
        result = 31 * result + this.leader.hashCode();
        result = 31 * result + (int)(this.index ^ this.index >>> 32);
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        result = 31 * result + this.members.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConfigureRequest that = (ConfigureRequest)o;
        if (this.term != that.term) {
            return false;
        }
        if (this.index != that.index) {
            return false;
        }
        if (this.timestamp != that.timestamp) {
            return false;
        }
        if (!this.leader.equals(that.leader)) {
            return false;
        }
        return this.members.equals(that.members);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("term", this.term).add("leader", (Object)this.leader).add("index", this.index).add("timestamp", this.timestamp).add("members", this.members).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, ConfigureRequest> {
        private long term;
        private String leader;
        private long index;
        private long timestamp;
        private Collection<RaftMember> members;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withLeader(MemberId leader) {
            this.leader = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)leader, (Object)"leader cannot be null")).id());
            return this;
        }

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withTime(long timestamp) {
            Preconditions.checkArgument((timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            this.timestamp = timestamp;
            return this;
        }

        public Builder withMembers(Collection<RaftMember> members) {
            this.members = (Collection)Preconditions.checkNotNull(members, (Object)"members cannot be null");
            return this;
        }

        public ConfigureRequest build() {
            this.validate();
            return new ConfigureRequest(this.term, this.leader, this.index, this.timestamp, this.members);
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.leader, (Object)"leader cannot be null");
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.timestamp > 0L ? 1 : 0) != 0, (Object)"timestamp must be positive");
            Preconditions.checkNotNull(this.members, (Object)"members cannot be null");
        }
    }
}

