/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.roles;

import io.atomix.raft.RaftError;
import io.atomix.raft.RaftServer;
import io.atomix.raft.impl.RaftContext;
import io.atomix.raft.metrics.SnapshotReplicationMetrics;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.RaftResponse;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import io.atomix.raft.roles.InactiveRole;
import io.atomix.raft.roles.RaftRole;
import io.atomix.raft.snapshot.impl.SnapshotChunkImpl;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.PersistedRaftRecord;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogReader;
import io.camunda.zeebe.journal.JournalException;
import io.camunda.zeebe.snapshots.PersistedSnapshot;
import io.camunda.zeebe.snapshots.ReceivedSnapshot;
import io.camunda.zeebe.snapshots.SnapshotChunk;
import java.nio.ByteBuffer;
import java.util.concurrent.CompletableFuture;
import org.agrona.DirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class PassiveRole
extends InactiveRole {
    private final SnapshotReplicationMetrics snapshotReplicationMetrics;
    private long pendingSnapshotStartTimestamp;
    private ReceivedSnapshot pendingSnapshot;
    private ByteBuffer nextPendingSnapshotChunkId;

    public PassiveRole(RaftContext context) {
        super(context);
        this.snapshotReplicationMetrics = new SnapshotReplicationMetrics(context.getName());
        this.snapshotReplicationMetrics.setCount(0);
    }

    @Override
    public CompletableFuture<RaftRole> start() {
        return ((CompletableFuture)super.start().thenRun(this::truncateUncommittedEntries)).thenApply(v -> this);
    }

    @Override
    public CompletableFuture<Void> stop() {
        this.abortPendingSnapshots();
        try {
            this.raft.getPersistedSnapshotStore().purgePendingSnapshots().join();
        }
        catch (Exception e) {
            this.log.warn("Failed to purge pending snapshots, which may result in unnecessary disk usage and should be monitored", (Throwable)e);
        }
        return super.stop();
    }

    private void truncateUncommittedEntries() {
        if (this.role() == RaftServer.Role.PASSIVE && this.raft.getLog().getLastIndex() > this.raft.getCommitIndex()) {
            this.raft.getLog().deleteAfter(this.raft.getCommitIndex());
            this.raft.getLog().flush();
            this.raft.setLastWrittenIndex(this.raft.getCommitIndex());
        }
    }

    @Override
    public RaftServer.Role role() {
        return RaftServer.Role.PASSIVE;
    }

    @Override
    public CompletableFuture<InstallResponse> onInstall(InstallRequest request) {
        long latestIndex;
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.currentTerm(), request.leader());
        this.log.debug("Received snapshot {} chunk from {}", (Object)request.index(), (Object)request.leader());
        if (request.currentTerm() < this.raft.getTerm()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request term is less than the local term " + request.currentTerm())).build()));
        }
        if (this.raft.getCommitIndex() > request.index()) {
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
        }
        if (this.pendingSnapshot != null && request.index() != this.pendingSnapshot.index()) {
            this.abortPendingSnapshots();
        }
        if ((latestIndex = this.raft.getCurrentSnapshotIndex()) >= request.index()) {
            this.abortPendingSnapshots();
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
        }
        if (!request.complete() && request.nextChunkId() == null) {
            this.abortPendingSnapshots();
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.PROTOCOL_ERROR, "Snapshot installation is not complete but did not provide any next expected chunk")).build()));
        }
        SnapshotChunkImpl snapshotChunk = new SnapshotChunkImpl();
        UnsafeBuffer snapshotChunkBuffer = new UnsafeBuffer(request.data());
        if (!snapshotChunk.tryWrap((DirectBuffer)snapshotChunkBuffer)) {
            this.abortPendingSnapshots();
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.APPLICATION_ERROR, "Failed to parse request data")).build()));
        }
        if (this.pendingSnapshot == null) {
            if (!request.isInitial()) {
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Request chunk offset is invalid")).build()));
            }
            this.pendingSnapshot = this.raft.getPersistedSnapshotStore().newReceivedSnapshot(snapshotChunk.getSnapshotId());
            this.log.info("Started receiving new snapshot {} from {}", (Object)this.pendingSnapshot, (Object)request.leader());
            this.pendingSnapshotStartTimestamp = System.currentTimeMillis();
            this.snapshotReplicationMetrics.incrementCount();
            this.raft.notifySnapshotReplicationStarted();
        } else if (!this.isExpectedChunk(request.chunkId())) {
            this.abortPendingSnapshots();
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Snapshot chunk is received out of order")).build()));
        }
        try {
            this.pendingSnapshot.apply((SnapshotChunk)snapshotChunk).join();
        }
        catch (Exception e) {
            this.log.warn("Failed to write pending snapshot chunk {}, rolling back snapshot {}", new Object[]{snapshotChunk, this.pendingSnapshot, e});
            this.abortPendingSnapshots();
            return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.APPLICATION_ERROR, "Failed to write pending snapshot chunk")).build()));
        }
        if (request.complete()) {
            long elapsed = System.currentTimeMillis() - this.pendingSnapshotStartTimestamp;
            this.log.debug("Committing snapshot {}", (Object)this.pendingSnapshot);
            try {
                this.resetLogOnReceivingSnapshot(this.pendingSnapshot.index());
                PersistedSnapshot snapshot = (PersistedSnapshot)this.pendingSnapshot.persist().join();
                this.log.info("Committed snapshot {}", (Object)snapshot);
            }
            catch (Exception e) {
                this.log.error("Failed to commit pending snapshot {}, rolling back", (Object)this.pendingSnapshot, (Object)e);
                this.abortPendingSnapshots();
                return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.APPLICATION_ERROR, "Failed to commit pending snapshot")).build()));
            }
            this.pendingSnapshot = null;
            this.pendingSnapshotStartTimestamp = 0L;
            this.snapshotReplicationMetrics.decrementCount();
            this.snapshotReplicationMetrics.observeDuration(elapsed);
            this.onSnapshotReceiveCompletedOrAborted();
        } else {
            this.setNextExpected(request.nextChunkId());
        }
        return CompletableFuture.completedFuture(this.logResponse(((InstallResponse.Builder)InstallResponse.builder().withStatus(RaftResponse.Status.OK)).build()));
    }

    @Override
    public CompletableFuture<ReconfigureResponse> onReconfigure(ReconfigureRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        if (this.raft.getLeader() == null) {
            return CompletableFuture.completedFuture(this.logResponse(((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build()));
        }
        return ((CompletableFuture)this.forward(request, this.raft.getProtocol()::reconfigure).exceptionally(error -> ((ReconfigureResponse.Builder)((ReconfigureResponse.Builder)ReconfigureResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.NO_LEADER)).build())).thenApply(this::logResponse);
    }

    @Override
    public CompletableFuture<AppendResponse> onAppend(AppendRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), request.leader());
        return this.handleAppend(request);
    }

    @Override
    public CompletableFuture<PollResponse> onPoll(PollRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        return CompletableFuture.completedFuture(this.logResponse(((PollResponse.Builder)((PollResponse.Builder)PollResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot poll RESERVE member")).build()));
    }

    @Override
    public CompletableFuture<VoteResponse> onVote(VoteRequest request) {
        this.raft.checkThread();
        this.logRequest(request);
        this.updateTermAndLeader(request.term(), null);
        return CompletableFuture.completedFuture(this.logResponse(((VoteResponse.Builder)((VoteResponse.Builder)VoteResponse.builder().withStatus(RaftResponse.Status.ERROR)).withError(RaftError.Type.ILLEGAL_MEMBER_STATE, "Cannot request vote from RESERVE member")).build()));
    }

    private void onSnapshotReceiveCompletedOrAborted() {
        this.raft.notifySnapshotReplicationCompleted();
    }

    private void setNextExpected(ByteBuffer nextChunkId) {
        this.nextPendingSnapshotChunkId = nextChunkId;
    }

    private boolean isExpectedChunk(ByteBuffer chunkId) {
        return this.nextPendingSnapshotChunkId == null || this.nextPendingSnapshotChunkId.equals(chunkId);
    }

    private void abortPendingSnapshots() {
        if (this.pendingSnapshot != null) {
            this.setNextExpected(null);
            this.log.info("Rolling back snapshot {}", (Object)this.pendingSnapshot);
            try {
                this.pendingSnapshot.abort();
            }
            catch (Exception e) {
                this.log.error("Failed to abort pending snapshot, clearing status anyway", (Throwable)e);
            }
            this.pendingSnapshot = null;
            this.pendingSnapshotStartTimestamp = 0L;
            this.snapshotReplicationMetrics.decrementCount();
            this.onSnapshotReceiveCompletedOrAborted();
        }
    }

    protected CompletableFuture<AppendResponse> handleAppend(AppendRequest request) {
        CompletableFuture<AppendResponse> future = new CompletableFuture<AppendResponse>();
        if (!this.checkTerm(request, future)) {
            return future;
        }
        if (!this.checkPreviousEntry(request, future)) {
            return future;
        }
        this.appendEntries(request, future);
        this.abortPendingSnapshots();
        return future;
    }

    protected boolean checkTerm(AppendRequest request, CompletableFuture<AppendResponse> future) {
        if (request.term() < this.raft.getTerm()) {
            this.log.debug("Rejected {}: request term is less than the current term ({})", (Object)request, (Object)this.raft.getTerm());
            return this.failAppend(this.raft.getLog().getLastIndex(), future);
        }
        return true;
    }

    protected boolean checkPreviousEntry(AppendRequest request, CompletableFuture<AppendResponse> future) {
        if (request.prevLogTerm() != 0L) {
            IndexedRaftLogEntry lastEntry = this.raft.getLog().getLastEntry();
            if (lastEntry != null) {
                return this.checkPreviousEntry(request, lastEntry.index(), lastEntry.term(), future);
            }
            PersistedSnapshot currentSnapshot = this.raft.getCurrentSnapshot();
            if (currentSnapshot != null) {
                return this.checkPreviousEntry(request, currentSnapshot.getIndex(), currentSnapshot.getTerm(), future);
            }
            if (request.prevLogIndex() > 0L) {
                this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index (0)", (Object)request, (Object)request.prevLogIndex());
                return this.failAppend(0L, future);
            }
        }
        return true;
    }

    private boolean checkPreviousEntry(AppendRequest request, long lastEntryIndex, long lastEntryTerm, CompletableFuture<AppendResponse> future) {
        block12: {
            if (request.prevLogIndex() > lastEntryIndex) {
                this.log.debug("Rejected {}: Previous index ({}) is greater than the local log's last index ({})", new Object[]{request, request.prevLogIndex(), lastEntryIndex});
                return this.failAppend(lastEntryIndex, future);
            }
            if (request.prevLogIndex() < lastEntryIndex) {
                try (RaftLogReader reader = this.raft.getLog().openUncommittedReader();){
                    reader.seek(request.prevLogIndex());
                    if (!reader.hasNext()) {
                        this.log.debug("Rejected {}: Previous entry does not exist in the local log", (Object)request);
                        boolean bl = this.failAppend(lastEntryIndex, future);
                        return bl;
                    }
                    IndexedRaftLogEntry previousEntry = (IndexedRaftLogEntry)reader.next();
                    if (request.prevLogTerm() != previousEntry.term()) {
                        this.log.debug("Rejected {}: Previous entry term ({}) does not match local log's term for the same entry ({})", new Object[]{request, request.prevLogTerm(), previousEntry.term()});
                        boolean bl = this.failAppend(request.prevLogIndex() - 1L, future);
                        return bl;
                    }
                    break block12;
                }
            }
            if (request.prevLogTerm() != lastEntryTerm) {
                this.log.debug("Rejected {}: Previous entry term ({}) does not equal the local log's last term ({})", new Object[]{request, request.prevLogTerm(), lastEntryTerm});
                return this.failAppend(request.prevLogIndex() - 1L, future);
            }
        }
        return true;
    }

    protected void appendEntries(AppendRequest request, CompletableFuture<AppendResponse> future) {
        long lastEntryIndex = request.prevLogIndex() + (long)request.entries().size();
        long commitIndex = Math.max(this.raft.getCommitIndex(), Math.min(request.commitIndex(), lastEntryIndex));
        long lastLogIndex = request.prevLogIndex();
        if (!request.entries().isEmpty()) {
            if (request.prevLogTerm() == 0L) {
                this.log.debug("Reset first index to {}", (Object)(request.prevLogIndex() + 1L));
                this.raft.getLog().reset(request.prevLogIndex() + 1L);
            }
            for (PersistedRaftRecord entry : request.entries()) {
                IndexedRaftLogEntry lastEntry;
                long index;
                boolean failedToAppend = this.tryToAppend(future, entry, index = ++lastLogIndex, lastEntry = this.raft.getLog().getLastEntry());
                if (failedToAppend) {
                    this.flush(lastLogIndex - 1L, request.prevLogIndex());
                    return;
                }
                if (this.role().active() || index != commitIndex) continue;
                break;
            }
        }
        this.raft.setFirstCommitIndex(request.commitIndex());
        long previousCommitIndex = this.raft.setCommitIndex(commitIndex);
        if (previousCommitIndex < commitIndex) {
            this.log.trace("Committed entries up to index {}", (Object)commitIndex);
            this.raft.notifyCommitListeners(commitIndex);
        }
        this.flush(lastLogIndex, request.prevLogIndex());
        this.succeedAppend(lastLogIndex, future);
    }

    private void flush(long lastWrittenIndex, long previousEntryIndex) {
        if (this.raft.getLog().shouldFlushExplicitly() && lastWrittenIndex > previousEntryIndex) {
            this.raft.getLog().flush();
            this.raft.setLastWrittenIndex(lastWrittenIndex);
        }
    }

    private boolean tryToAppend(CompletableFuture<AppendResponse> future, PersistedRaftRecord entry, long index, IndexedRaftLogEntry lastEntry) {
        boolean failedToAppend = false;
        if (lastEntry != null) {
            if (lastEntry.index() > index) {
                failedToAppend = !this.replaceExistingEntry(future, entry, index);
            } else if (lastEntry.index() == index) {
                if (lastEntry.term() != entry.term()) {
                    this.raft.getLog().deleteAfter(index - 1L);
                    this.raft.getLog().flush();
                    this.raft.setLastWrittenIndex(index - 1L);
                    failedToAppend = !this.appendEntry(index, entry, future);
                }
            } else {
                failedToAppend = !this.appendEntry(future, entry, index, lastEntry);
            }
        } else {
            failedToAppend = !this.appendEntry(index, entry, future);
        }
        return failedToAppend;
    }

    private boolean appendEntry(CompletableFuture<AppendResponse> future, PersistedRaftRecord entry, long index, IndexedRaftLogEntry lastEntry) {
        if (lastEntry.index() != index - 1L) {
            throw new IllegalStateException("Log writer inconsistent with next append entry index " + index);
        }
        return this.appendEntry(index, entry, future);
    }

    private boolean replaceExistingEntry(CompletableFuture<AppendResponse> future, PersistedRaftRecord entry, long index) {
        try (RaftLogReader reader = this.raft.getLog().openUncommittedReader();){
            reader.seek(index);
            if (!reader.hasNext()) {
                throw new IllegalStateException("Log reader inconsistent with log writer");
            }
            IndexedRaftLogEntry existingEntry = (IndexedRaftLogEntry)reader.next();
            if (existingEntry.term() != entry.term()) {
                this.raft.getLog().deleteAfter(index - 1L);
                this.raft.getLog().flush();
                this.raft.setLastWrittenIndex(index - 1L);
                boolean bl = this.appendEntry(index, entry, future);
                return bl;
            }
            boolean bl = true;
            return bl;
        }
    }

    private boolean appendEntry(long index, PersistedRaftRecord entry, CompletableFuture<AppendResponse> future) {
        try {
            IndexedRaftLogEntry indexed = this.raft.getLog().append(entry);
            this.log.trace("Appended {}", (Object)indexed);
            this.raft.getReplicationMetrics().setAppendIndex(indexed.index());
        }
        catch (JournalException.OutOfDiskSpace e) {
            this.log.trace("Append failed: ", (Throwable)e);
            this.raft.getLogCompactor().compact();
            this.failAppend(index - 1L, future);
            return false;
        }
        catch (JournalException.InvalidChecksum e) {
            this.log.debug("Entry checksum doesn't match entry data: ", (Throwable)e);
            this.failAppend(index - 1L, future);
            return false;
        }
        catch (JournalException.InvalidIndex e) {
            this.failAppend(index - 1L, future);
            return false;
        }
        return true;
    }

    protected boolean failAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(false, lastLogIndex, future);
    }

    protected boolean succeedAppend(long lastLogIndex, CompletableFuture<AppendResponse> future) {
        return this.completeAppend(true, lastLogIndex, future);
    }

    protected boolean completeAppend(boolean succeeded, long lastLogIndex, CompletableFuture<AppendResponse> future) {
        future.complete(this.logResponse(((AppendResponse.Builder)AppendResponse.builder().withStatus(RaftResponse.Status.OK)).withTerm(this.raft.getTerm()).withSucceeded(succeeded).withLastLogIndex(lastLogIndex).withLastSnapshotIndex(this.raft.getCurrentSnapshotIndex()).build()));
        return succeeded;
    }

    private void resetLogOnReceivingSnapshot(long snapshotIndex) {
        RaftLog raftLog = this.raft.getLog();
        this.log.info("Delete existing log (lastIndex '{}') and replace with received snapshot (index '{}'). First entry in the log will be at index {}", new Object[]{raftLog.getLastIndex(), snapshotIndex, snapshotIndex + 1L});
        raftLog.reset(snapshotIndex + 1L);
    }
}

