/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.cluster.MemberId;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.storage.log.entry.ApplicationEntry;
import io.atomix.raft.storage.log.entry.ConfigurationEntry;
import io.atomix.raft.storage.log.entry.InitialEntry;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.serializer.ApplicationEntryDecoder;
import io.atomix.raft.storage.serializer.ApplicationEntryEncoder;
import io.atomix.raft.storage.serializer.ConfigurationEntryDecoder;
import io.atomix.raft.storage.serializer.ConfigurationEntryEncoder;
import io.atomix.raft.storage.serializer.EntryType;
import io.atomix.raft.storage.serializer.MessageHeaderDecoder;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import io.atomix.raft.storage.serializer.RaftLogEntryDecoder;
import io.atomix.raft.storage.serializer.RaftLogEntryEncoder;
import io.atomix.raft.storage.serializer.SerializerUtil;
import java.time.Instant;
import java.util.ArrayList;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.UnsafeBuffer;

public class RaftEntrySBESerializer
implements RaftEntrySerializer {
    final MessageHeaderEncoder headerEncoder = new MessageHeaderEncoder();
    final RaftLogEntryEncoder raftLogEntryEncoder = new RaftLogEntryEncoder();
    final ApplicationEntryEncoder applicationEntryEncoder = new ApplicationEntryEncoder();
    final ConfigurationEntryEncoder configurationEntryEncoder = new ConfigurationEntryEncoder();
    final MessageHeaderDecoder headerDecoder = new MessageHeaderDecoder();
    final RaftLogEntryDecoder raftLogEntryDecoder = new RaftLogEntryDecoder();
    final ApplicationEntryDecoder applicationEntryDecoder = new ApplicationEntryDecoder();
    final ConfigurationEntryDecoder configurationEntryDecoder = new ConfigurationEntryDecoder();

    @Override
    public int writeApplicationEntry(long term, ApplicationEntry entry, MutableDirectBuffer buffer, int offset) {
        int entryOffset = this.writeRaftFrame(term, EntryType.ApplicationEntry, buffer, offset);
        this.headerEncoder.wrap(buffer, offset + entryOffset).blockLength(this.applicationEntryEncoder.sbeBlockLength()).templateId(this.applicationEntryEncoder.sbeTemplateId()).schemaId(this.applicationEntryEncoder.sbeSchemaId()).version(this.applicationEntryEncoder.sbeSchemaVersion());
        this.applicationEntryEncoder.wrap(buffer, offset + entryOffset + this.headerEncoder.encodedLength());
        this.applicationEntryEncoder.lowestAsqn(entry.lowestPosition()).highestAsqn(entry.highestPosition()).putApplicationData((DirectBuffer)new UnsafeBuffer(entry.data()), 0, entry.data().capacity());
        return entryOffset + this.headerEncoder.encodedLength() + this.applicationEntryEncoder.encodedLength();
    }

    @Override
    public int writeInitialEntry(long term, InitialEntry entry, MutableDirectBuffer buffer, int offset) {
        return this.writeRaftFrame(term, EntryType.InitialEntry, buffer, offset);
    }

    @Override
    public int writeConfigurationEntry(long term, ConfigurationEntry entry, MutableDirectBuffer buffer, int offset) {
        int entryOffset = this.writeRaftFrame(term, EntryType.ConfigurationEntry, buffer, offset);
        this.headerEncoder.wrap(buffer, offset + entryOffset).blockLength(this.configurationEntryEncoder.sbeBlockLength()).templateId(this.configurationEntryEncoder.sbeTemplateId()).schemaId(this.configurationEntryEncoder.sbeSchemaId()).version(this.configurationEntryEncoder.sbeSchemaVersion());
        this.configurationEntryEncoder.wrap(buffer, offset + entryOffset + this.headerEncoder.encodedLength());
        this.configurationEntryEncoder.timestamp(entry.timestamp());
        ConfigurationEntryEncoder.RaftMemberEncoder raftMemberEncoder = this.configurationEntryEncoder.raftMemberCount(entry.members().size());
        for (RaftMember member : entry.members()) {
            String memberId = (String)((Object)member.memberId().id());
            raftMemberEncoder.next().type(SerializerUtil.getSBEType(member.getType())).updated(member.getLastUpdated().toEpochMilli()).memberId(memberId);
        }
        return entryOffset + this.headerEncoder.encodedLength() + this.configurationEntryEncoder.encodedLength();
    }

    @Override
    public RaftLogEntry readRaftLogEntry(DirectBuffer buffer) {
        this.headerDecoder.wrap(buffer, 0);
        this.raftLogEntryDecoder.wrap(buffer, this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        long term = this.raftLogEntryDecoder.term();
        EntryType type = this.raftLogEntryDecoder.type();
        int entryOffset = this.headerDecoder.encodedLength() + this.raftLogEntryDecoder.encodedLength();
        return new RaftLogEntry(term, switch (type) {
            case EntryType.ApplicationEntry -> {
                this.headerDecoder.wrap(buffer, entryOffset);
                yield this.readApplicationEntry(buffer, entryOffset);
            }
            case EntryType.ConfigurationEntry -> {
                this.headerDecoder.wrap(buffer, entryOffset);
                yield this.readConfigurationEntry(buffer, entryOffset);
            }
            case EntryType.InitialEntry -> new InitialEntry();
            default -> throw new IllegalStateException("Unexpected entry type " + type);
        });
    }

    private int writeRaftFrame(long term, EntryType entryType, MutableDirectBuffer buffer, int offset) {
        this.headerEncoder.wrap(buffer, offset).blockLength(this.raftLogEntryEncoder.sbeBlockLength()).templateId(this.raftLogEntryEncoder.sbeTemplateId()).schemaId(this.raftLogEntryEncoder.sbeSchemaId()).version(this.raftLogEntryEncoder.sbeSchemaVersion());
        this.raftLogEntryEncoder.wrap(buffer, offset + this.headerEncoder.encodedLength());
        this.raftLogEntryEncoder.term(term);
        this.raftLogEntryEncoder.type(entryType);
        return this.headerEncoder.encodedLength() + this.raftLogEntryEncoder.encodedLength();
    }

    private ApplicationEntry readApplicationEntry(DirectBuffer buffer, int entryOffset) {
        this.applicationEntryDecoder.wrap(buffer, entryOffset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        UnsafeBuffer data = new UnsafeBuffer();
        this.applicationEntryDecoder.wrapApplicationData((DirectBuffer)data);
        return new ApplicationEntry(this.applicationEntryDecoder.lowestAsqn(), this.applicationEntryDecoder.highestAsqn(), (DirectBuffer)data);
    }

    private ConfigurationEntry readConfigurationEntry(DirectBuffer buffer, int entryOffset) {
        this.configurationEntryDecoder.wrap(buffer, entryOffset + this.headerDecoder.encodedLength(), this.headerDecoder.blockLength(), this.headerDecoder.version());
        long timestamp = this.configurationEntryDecoder.timestamp();
        ConfigurationEntryDecoder.RaftMemberDecoder memberDecoder = this.configurationEntryDecoder.raftMember();
        ArrayList<RaftMember> members = new ArrayList<RaftMember>(memberDecoder.count());
        for (ConfigurationEntryDecoder.RaftMemberDecoder member : memberDecoder) {
            RaftMember.Type type = SerializerUtil.getRaftMemberType(member.type());
            Instant updated = Instant.ofEpochMilli(member.updated());
            String memberId = member.memberId();
            members.add(new DefaultRaftMember(MemberId.from(memberId), type, updated));
        }
        return new ConfigurationEntry(timestamp, members);
    }
}

