/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class PartitionMetadata {
    private final PartitionId id;
    private final Set<MemberId> members;
    private final Map<MemberId, Integer> priority;
    private final int targetPriority;
    private final MemberId primary;

    public PartitionMetadata(PartitionId id, Set<MemberId> members, Map<MemberId, Integer> priority, int targetPriority, MemberId primary) {
        this.id = id;
        this.members = members;
        this.priority = priority;
        this.targetPriority = targetPriority;
        this.primary = primary;
    }

    public PartitionId id() {
        return this.id;
    }

    public Collection<MemberId> members() {
        return this.members;
    }

    public int getPriority(MemberId member) {
        return this.priority.getOrDefault(member, -1);
    }

    public Optional<MemberId> getPrimary() {
        return Optional.ofNullable(this.primary);
    }

    public int getTargetPriority() {
        return this.targetPriority;
    }

    public int hashCode() {
        return Objects.hash(this.id, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof PartitionMetadata) {
            PartitionMetadata partition = (PartitionMetadata)object;
            return partition.id.equals(this.id) && partition.members.equals(this.members);
        }
        return false;
    }

    public String toString() {
        return "PartitionMetadata{id=" + this.id + ", primary=" + this.primary + ", members=" + this.members + ", priority=" + this.priority + ", targetPriority=" + this.targetPriority + "}";
    }
}

