/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import io.atomix.raft.metrics.RaftServiceMetrics;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.utils.concurrent.ThreadContext;
import org.agrona.LangUtil;
import org.slf4j.Logger;

public final class LogCompactor {
    private final ThreadContext threadContext;
    private final RaftLog log;
    private final int replicationThreshold;
    private final Logger logger;
    private final RaftServiceMetrics metrics;
    private volatile long compactableIndex;

    public LogCompactor(ThreadContext threadContext, RaftLog log, int replicationThreshold, RaftServiceMetrics metrics, Logger logger) {
        this.threadContext = threadContext;
        this.log = log;
        this.replicationThreshold = replicationThreshold;
        this.metrics = metrics;
        this.logger = logger;
    }

    public boolean compact() {
        return this.compact(this.compactableIndex - (long)this.replicationThreshold);
    }

    public boolean compactIgnoringReplicationThreshold() {
        return this.compact(this.compactableIndex);
    }

    private boolean compact(long index) {
        this.threadContext.checkThread();
        try {
            long startTime = System.currentTimeMillis();
            boolean compacted = this.log.deleteUntil(index);
            this.metrics.compactionTime(System.currentTimeMillis() - startTime);
            this.logger.debug("Compacted log up to index {}", (Object)index);
            return compacted;
        }
        catch (Exception e) {
            this.logger.error("Failed to compact up to index {}", (Object)index, (Object)e);
            LangUtil.rethrowUnchecked((Throwable)e);
            return false;
        }
    }

    public void setCompactableIndex(long index) {
        this.compactableIndex = index;
    }
}

