/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.primitive.partition;

import com.google.common.hash.Hashing;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroupConfig;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.utils.NamedType;
import io.atomix.utils.config.Configured;
import io.atomix.utils.serializer.Namespace;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public interface PartitionGroup
extends Configured<PartitionGroupConfig> {
    public String name();

    public Partition getPartition(int var1);

    public Partition getPartition(PartitionId var1);

    default public Partition getPartition(String key) {
        int hashCode = Hashing.sha256().hashString((CharSequence)key, StandardCharsets.UTF_8).asInt();
        return this.getPartition(this.getPartitionIds().get(Math.abs(hashCode) % this.getPartitionIds().size()));
    }

    public Collection<Partition> getPartitions();

    public List<PartitionId> getPartitionIds();

    default public List<Partition> getPartitionsWithMember(MemberId memberId) {
        return this.getPartitions().stream().filter(partition -> partition.members().contains(memberId)).collect(Collectors.toList());
    }

    public static interface Type<C extends PartitionGroupConfig<C>>
    extends NamedType {
        public Namespace namespace();

        public ManagedPartitionGroup newPartitionGroup(C var1);
    }

    public static abstract class Builder<C extends PartitionGroupConfig<C>>
    implements io.atomix.utils.Builder<ManagedPartitionGroup> {
        protected final C config;

        protected Builder(C config) {
            this.config = config;
        }
    }
}

