/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import com.google.common.collect.Sets;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.PartitionDistributor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RoundRobinPartitionDistributor
implements PartitionDistributor {
    @Override
    public Set<PartitionMetadata> distributePartitions(Set<MemberId> clusterMembers, List<PartitionId> sortedPartitionIds, int replicationFactor) {
        ArrayList<MemberId> sorted = new ArrayList<MemberId>(clusterMembers);
        Collections.sort(sorted);
        int length = sorted.size();
        int count = Math.min(replicationFactor, length);
        HashSet metadata = Sets.newHashSet();
        for (int i = 0; i < sortedPartitionIds.size(); ++i) {
            PartitionId partitionId = sortedPartitionIds.get(i);
            ArrayList<MemberId> membersForPartition = new ArrayList<MemberId>(count);
            for (int j = 0; j < count; ++j) {
                membersForPartition.add((MemberId)sorted.get((i + j) % length));
            }
            MemberId primary = (MemberId)sorted.get(i % length);
            Map<MemberId, Integer> priorities = this.getPriorities(partitionId, membersForPartition, primary, sorted.size(), replicationFactor);
            metadata.add(new PartitionMetadata(partitionId, Set.copyOf(membersForPartition), priorities, priorities.get(primary), primary));
        }
        return metadata;
    }

    private Map<MemberId, Integer> getPriorities(PartitionId partitionId, List<MemberId> membersForPartition, MemberId primary, int clusterSize, int replicationFactor) {
        HashMap<MemberId, Integer> priority = new HashMap<MemberId, Integer>();
        boolean lowestPriority = true;
        priority.put(primary, replicationFactor);
        if (((Integer)partitionId.id() - 1) / clusterSize % 2 == 0) {
            int nextPriority = replicationFactor - 1;
            for (MemberId member : membersForPartition) {
                if (member.equals(primary)) continue;
                priority.put(member, nextPriority);
                --nextPriority;
            }
        } else {
            int nextPriority = 1;
            for (MemberId member : membersForPartition) {
                if (member.equals(primary)) continue;
                priority.put(member, nextPriority);
                ++nextPriority;
            }
        }
        return priority;
    }
}

