/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.MessagingMetrics;
import io.camunda.zeebe.util.CloseableSilently;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

final class MessagingMetricsImpl
implements MessagingMetrics {
    private static final String NAMESPACE = "zeebe";
    private static final String LABEL_TOPIC = "topic";
    private static final String LABEL_ADDRESS = "address";
    private static final String REQ_TYPE_MESSAGE = "MESSAGE";
    private static final String REQ_TYPE_REQ_RESP = "REQ_RESP";
    private static final Histogram REQUEST_RESPONSE_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("messaging_request_response_latency")).help("The time how long it takes to retrieve a response for a request")).labelNames(new String[]{"topic"})).register();
    private static final Histogram REQUEST_SIZE_IN_KB = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("zeebe")).name("messaging_request_size_kb")).help("The size of the request, which has been sent")).labelNames(new String[]{"address", "topic"})).buckets(new double[]{0.01, 0.1, 0.25, 1.0, 10.0, 100.0, 500.0, 1000.0, 2000.0, 4000.0}).register();
    private static final Counter REQUEST_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("messaging_request_count")).help("Number of requests which has been send to a certain address")).labelNames(new String[]{"type", "address", "topic"})).register();
    private static final Counter RESPONSE_COUNT = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("zeebe")).name("messaging_response_count")).help("Number of responses which has been received")).labelNames(new String[]{"address", "topic", "outcome"})).register();
    private static final Gauge IN_FLIGHT_REQUESTS = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("zeebe")).name("messaging_inflight_requests")).help("The count of inflight requests")).labelNames(new String[]{"address", "topic"})).register();

    MessagingMetricsImpl() {
    }

    @Override
    public CloseableSilently startRequestTimer(String name) {
        Histogram.Timer timer = ((Histogram.Child)REQUEST_RESPONSE_LATENCY.labels(new String[]{name})).startTimer();
        return () -> ((Histogram.Timer)timer).close();
    }

    @Override
    public void observeRequestSize(String to, String name, int requestSizeInBytes) {
        ((Histogram.Child)REQUEST_SIZE_IN_KB.labels(new String[]{to, name})).observe((double)((float)requestSizeInBytes / 1000.0f));
    }

    @Override
    public void countMessage(String to, String name) {
        ((Counter.Child)REQUEST_COUNT.labels(new String[]{REQ_TYPE_MESSAGE, to, name})).inc();
    }

    @Override
    public void countRequestResponse(String to, String name) {
        ((Counter.Child)REQUEST_COUNT.labels(new String[]{REQ_TYPE_REQ_RESP, to, name})).inc();
    }

    @Override
    public void countSuccessResponse(String address, String name) {
        ((Counter.Child)RESPONSE_COUNT.labels(new String[]{address, name, "SUCCESS"})).inc();
    }

    @Override
    public void countFailureResponse(String address, String name, String error) {
        ((Counter.Child)RESPONSE_COUNT.labels(new String[]{address, name, error})).inc();
    }

    @Override
    public void incInFlightRequests(String address, String topic) {
        ((Gauge.Child)IN_FLIGHT_REQUESTS.labels(new String[]{address, topic})).inc();
    }

    @Override
    public void decInFlightRequests(String address, String topic) {
        ((Gauge.Child)IN_FLIGHT_REQUESTS.labels(new String[]{address, topic})).dec();
    }
}

