/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.atomix.cluster.messaging.impl.AbstractClientConnection;
import io.atomix.cluster.messaging.impl.MessagingMetrics;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.camunda.zeebe.util.CloseableSilently;
import io.netty.channel.Channel;
import java.util.concurrent.CompletableFuture;

final class RemoteClientConnection
extends AbstractClientConnection {
    private final Channel channel;
    private final MessagingMetrics messagingMetrics;

    RemoteClientConnection(MessagingMetrics messagingMetrics, Channel channel) {
        this.messagingMetrics = messagingMetrics;
        this.channel = channel;
    }

    @Override
    public CompletableFuture<Void> sendAsync(ProtocolRequest message) {
        CompletableFuture<Void> future = new CompletableFuture<Void>();
        this.countMessageMetrics(message);
        this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
            if (!channelFuture.isSuccess()) {
                future.completeExceptionally(channelFuture.cause());
            } else {
                future.complete(null);
            }
        });
        return future;
    }

    @Override
    public CompletableFuture<byte[]> sendAndReceive(ProtocolRequest message) {
        CompletableFuture<byte[]> responseFuture = this.awaitResponseForRequestWithId(message.id());
        this.countReqResponseMetrics(message, responseFuture);
        this.channel.writeAndFlush((Object)message).addListener(channelFuture -> {
            if (!channelFuture.isSuccess()) {
                responseFuture.completeExceptionally(channelFuture.cause());
            }
        });
        return responseFuture;
    }

    private void countMessageMetrics(ProtocolRequest message) {
        String toAddress = this.channel.remoteAddress().toString();
        String subject = message.subject();
        this.messagingMetrics.countMessage(this.channel.remoteAddress().toString(), message.subject());
        byte[] payload = message.payload();
        this.messagingMetrics.observeRequestSize(toAddress, subject, payload == null ? 0 : payload.length);
    }

    private void countReqResponseMetrics(ProtocolRequest message, CompletableFuture<byte[]> responseFuture) {
        String toAddress = this.channel.remoteAddress().toString();
        String subject = message.subject();
        this.messagingMetrics.countRequestResponse(toAddress, subject);
        this.messagingMetrics.incInFlightRequests(toAddress, subject);
        CloseableSilently timer = this.messagingMetrics.startRequestTimer(subject);
        byte[] payload = message.payload();
        this.messagingMetrics.observeRequestSize(toAddress, subject, payload == null ? 0 : payload.length);
        responseFuture.whenComplete((success, failure) -> {
            timer.close();
            this.messagingMetrics.decInFlightRequests(toAddress, subject);
            if (failure != null) {
                this.messagingMetrics.countFailureResponse(toAddress, subject, failure.getClass().getName());
            } else {
                this.messagingMetrics.countSuccessResponse(toAddress, subject);
            }
        });
    }

    public String toString() {
        return "RemoteClientConnection{channel=" + this.channel + "}";
    }
}

