/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public class LeaderMetrics
extends RaftMetrics {
    private static final String FOLLOWER_LABEL = "follower";
    private static final Histogram APPEND_LATENCY = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("append_entries_latency")).help("Latency to append an entry to a follower")).labelNames(new String[]{"follower", "partitionGroupName", "partition"})).register();
    private static final Counter APPEND_RATE = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("atomix")).name("append_entries_rate")).help("The count of entries appended (counting entries, not their size)")).labelNames(new String[]{"follower", "partitionGroupName", "partition"})).register();
    private static final Counter APPEND_DATA_RATE = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("atomix")).name("append_entries_data_rate")).help("The count of data replication in KiB")).labelNames(new String[]{"follower", "partitionGroupName", "partition"})).register();
    private static final Gauge NON_REPLICATED_ENTRIES = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("non_replicated_entries")).help("The number of non-replicated entries for a given followers")).labelNames(new String[]{"follower", "partitionGroupName", "partition"})).register();
    private static final Counter COMMIT_RATE = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("atomix")).name("commit_entries_rate")).help("The count of entries committed (counting entries, not their size)")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private static final Gauge NON_COMMITTED_ENTRIES = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("non_committed_entries")).help("The number of non-committed entries on the leader")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private final Counter.Child commitRate;
    private final Gauge.Child nonCommittedEntries;

    public LeaderMetrics(String partitionName) {
        super(partitionName);
        this.commitRate = (Counter.Child)COMMIT_RATE.labels(new String[]{this.partitionGroupName, this.partition});
        this.nonCommittedEntries = (Gauge.Child)NON_COMMITTED_ENTRIES.labels(new String[]{this.partitionGroupName, this.partition});
    }

    public void appendComplete(long latencyms, String memberId) {
        ((Histogram.Child)APPEND_LATENCY.labels(new String[]{memberId, this.partitionGroupName, this.partition})).observe((double)((float)latencyms / 1000.0f));
    }

    public void observeAppend(String memberId, int appendedEntries, int appendedBytes) {
        ((Counter.Child)APPEND_RATE.labels(new String[]{memberId, this.partitionGroupName, this.partition})).inc((double)appendedEntries);
        ((Counter.Child)APPEND_DATA_RATE.labels(new String[]{memberId, this.partitionGroupName, this.partition})).inc((double)((float)appendedBytes / 1024.0f));
    }

    public void observeCommit() {
        this.commitRate.inc();
    }

    public void observeNonCommittedEntries(long remainingEntries) {
        this.nonCommittedEntries.set((double)remainingEntries);
    }

    public void observeRemainingEntries(String memberId, long remainingEntries) {
        ((Gauge.Child)NON_REPLICATED_ENTRIES.labels(new String[]{memberId, this.partitionGroupName, this.partition})).set((double)remainingEntries);
    }
}

