/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import io.atomix.cluster.Member;
import io.atomix.cluster.MemberId;
import io.atomix.primitive.partition.ManagedPartitionGroup;
import io.atomix.primitive.partition.Partition;
import io.atomix.primitive.partition.PartitionGroup;
import io.atomix.primitive.partition.PartitionId;
import io.atomix.primitive.partition.PartitionManagementService;
import io.atomix.primitive.partition.PartitionMetadata;
import io.atomix.raft.partition.PartitionDistributor;
import io.atomix.raft.partition.RaftPartition;
import io.atomix.raft.partition.RaftPartitionGroupConfig;
import io.atomix.raft.partition.RaftStorageConfig;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.raft.zeebe.EntryValidator;
import io.atomix.utils.serializer.Namespace;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;
import java.io.File;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RaftPartitionGroup
implements ManagedPartitionGroup {
    public static final Type TYPE = new Type();
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftPartitionGroup.class);
    private final String name;
    private final RaftPartitionGroupConfig config;
    private final int replicationFactor;
    private final Map<PartitionId, RaftPartition> partitions = Maps.newConcurrentMap();
    private final List<PartitionId> sortedPartitionIds = Lists.newCopyOnWriteArrayList();
    private final Collection<PartitionMetadata> metadata;

    public RaftPartitionGroup(RaftPartitionGroupConfig config) {
        this.config = config;
        this.name = config.getName();
        this.replicationFactor = config.getReplicationFactor();
        RaftPartitionGroup.buildPartitions(config).forEach(p -> {
            this.partitions.put(p.id(), (RaftPartition)p);
            this.sortedPartitionIds.add(p.id());
        });
        Collections.sort(this.sortedPartitionIds);
        this.metadata = this.determinePartitionDistribution(config);
    }

    private Collection<PartitionMetadata> determinePartitionDistribution(RaftPartitionGroupConfig config) {
        Set<MemberId> members = config.getMembers().stream().map(MemberId::from).collect(Collectors.toSet());
        Set<PartitionMetadata> metadataCollection = config.getPartitionConfig().getPartitionDistributor().distributePartitions(members, this.sortedPartitionIds, this.replicationFactor);
        metadataCollection.forEach(partitionMetadata -> this.partitions.get(partitionMetadata.id()).setMetadata((PartitionMetadata)partitionMetadata));
        return metadataCollection;
    }

    private static Collection<RaftPartition> buildPartitions(RaftPartitionGroupConfig config) {
        File partitionsDir = new File(config.getStorageConfig().getDirectory(config.getName()), "partitions");
        ArrayList<RaftPartition> partitions = new ArrayList<RaftPartition>(config.getPartitionCount());
        for (int i = 0; i < config.getPartitionCount(); ++i) {
            partitions.add(new RaftPartition(PartitionId.from(config.getName(), i + 1), config, new File(partitionsDir, String.valueOf(i + 1))));
        }
        return partitions;
    }

    public static Builder builder(String name) {
        return new Builder((RaftPartitionGroupConfig)new RaftPartitionGroupConfig().setName(name));
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public RaftPartition getPartition(int partitionId) {
        return this.getPartition(PartitionId.from(this.name, partitionId));
    }

    @Override
    public RaftPartition getPartition(PartitionId partitionId) {
        return this.partitions.get(partitionId);
    }

    @Override
    public Collection<Partition> getPartitions() {
        return Collections.unmodifiableCollection(this.partitions.values());
    }

    @Override
    public List<PartitionId> getPartitionIds() {
        return this.sortedPartitionIds;
    }

    public RaftPartitionGroupConfig config() {
        return this.config;
    }

    public String toString() {
        return "RaftPartitionGroup{name='" + this.name + "', config=" + this.config + ", replicationFactor=" + this.replicationFactor + ", partitions=" + this.partitions + ", sortedPartitionIds=" + this.sortedPartitionIds + ", metadata=" + this.metadata + "}";
    }

    @Override
    public CompletableFuture<ManagedPartitionGroup> join(PartitionManagementService managementService) {
        CompletableFuture[] futures = (CompletableFuture[])this.metadata.stream().map(meta -> this.partitions.get(meta.id()).open(managementService)).toArray(CompletableFuture[]::new);
        return ((CompletableFuture)CompletableFuture.allOf(futures).thenRun(() -> LOGGER.info("Started RaftPartitionGroup {}", (Object)this.name))).thenApply(ok -> this);
    }

    @Override
    public CompletableFuture<ManagedPartitionGroup> connect(PartitionManagementService managementService) {
        return this.join(managementService);
    }

    @Override
    public CompletableFuture<Void> close() {
        CompletableFuture[] futures = (CompletableFuture[])this.partitions.values().stream().map(RaftPartition::close).toArray(CompletableFuture[]::new);
        return CompletableFuture.allOf(futures).thenRun(() -> LOGGER.info("Stopped RaftPartitionGroup {}", (Object)this.name));
    }

    public static class Builder
    extends PartitionGroup.Builder<RaftPartitionGroupConfig> {
        protected Builder(RaftPartitionGroupConfig config) {
            super(config);
        }

        public Builder withMembers(Collection<String> members) {
            ((RaftPartitionGroupConfig)this.config).setMembers(Sets.newHashSet((Iterable)((Iterable)Preconditions.checkNotNull(members, (Object)"members cannot be null"))));
            return this;
        }

        public Builder withMembers(Member ... members) {
            return this.withMembers(Stream.of(members).map(node -> (String)((Object)node.id().id())).collect(Collectors.toList()));
        }

        public Builder withNumPartitions(int numPartitions) {
            ((RaftPartitionGroupConfig)this.config).setPartitionCount(numPartitions);
            return this;
        }

        public Builder withPartitionSize(int partitionSize) {
            ((RaftPartitionGroupConfig)this.config).setReplicationFactor(partitionSize);
            return this;
        }

        public Builder withMaxAppendsPerFollower(int maxAppendsPerFollower) {
            Preconditions.checkArgument((maxAppendsPerFollower > 0 ? 1 : 0) != 0, (Object)"maxAppendsPerFollower must be positive");
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setMaxAppendsPerFollower(maxAppendsPerFollower);
            return this;
        }

        public Builder withMaxAppendBatchSize(int maxAppendBatchSize) {
            Preconditions.checkArgument((maxAppendBatchSize > 0 ? 1 : 0) != 0, (Object)"maxAppendBatchSize must be positive");
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setMaxAppendBatchSize(maxAppendBatchSize);
            return this;
        }

        public Builder withHeartbeatInterval(Duration heartbeatInterval) {
            Preconditions.checkArgument((heartbeatInterval.toMillis() > 0L ? 1 : 0) != 0, (Object)"heartbeatInterval must be atleast 1ms");
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setHeartbeatInterval(heartbeatInterval);
            return this;
        }

        public Builder withElectionTimeout(Duration electionTimeout) {
            Preconditions.checkArgument((electionTimeout.toMillis() > 0L ? 1 : 0) != 0, (Object)"heartbeatInterval must be atleast 1ms");
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setElectionTimeout(electionTimeout);
            return this;
        }

        public Builder withDataDirectory(File dataDir) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setDirectory(new File("user.dir").toURI().relativize(dataDir.toURI()).getPath());
            return this;
        }

        public Builder withSegmentSize(long segmentSizeBytes) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setSegmentSize(segmentSizeBytes);
            return this;
        }

        public Builder withFreeDiskSpace(long freeDiskSpace) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setFreeDiskSpace(freeDiskSpace);
            return this;
        }

        public Builder withFlusherFactory(RaftLogFlusher.Factory flusherFactory) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setFlusherFactory(flusherFactory);
            return this;
        }

        public Builder withSnapshotStoreFactory(ReceivableSnapshotStoreFactory persistedSnapshotStoreFactory) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setPersistedSnapshotStoreFactory(persistedSnapshotStoreFactory);
            return this;
        }

        public Builder withEntryValidator(EntryValidator entryValidator) {
            ((RaftPartitionGroupConfig)this.config).setEntryValidator(entryValidator);
            return this;
        }

        public Builder withJournalIndexDensity(int journalIndexDensity) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setJournalIndexDensity(journalIndexDensity);
            return this;
        }

        public Builder withPriorityElection(boolean enable) {
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setPriorityElectionEnabled(enable);
            return this;
        }

        public Builder withRequestTimeout(Duration requestTimeout) {
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setRequestTimeout(requestTimeout);
            return this;
        }

        public Builder withMinStepDownFailureCount(int minStepDownFailureCount) {
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setMinStepDownFailureCount(minStepDownFailureCount);
            return this;
        }

        public Builder withMaxQuorumResponseTimeout(Duration maxQuorumResponseTimeout) {
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setMaxQuorumResponseTimeout(maxQuorumResponseTimeout);
            return this;
        }

        public Builder withPartitionDistributor(PartitionDistributor partitionDistributor) {
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setPartitionDistributor(partitionDistributor);
            return this;
        }

        public Builder withPreferSnapshotReplicationThreshold(int preferSnapshotReplicationThreshold) {
            ((RaftPartitionGroupConfig)this.config).getPartitionConfig().setPreferSnapshotReplicationThreshold(preferSnapshotReplicationThreshold);
            return this;
        }

        public Builder withPreallocateSegmentFiles(boolean preallocateSegmentFiles) {
            ((RaftPartitionGroupConfig)this.config).getStorageConfig().setPreallocateSegmentFiles(preallocateSegmentFiles);
            return this;
        }

        public RaftPartitionGroup build() {
            return new RaftPartitionGroup((RaftPartitionGroupConfig)this.config);
        }
    }

    public static class Type
    implements PartitionGroup.Type<RaftPartitionGroupConfig> {
        private static final String NAME = "raft";

        public String name() {
            return NAME;
        }

        @Override
        public Namespace namespace() {
            return new Namespace.Builder().nextId(600).register(new Class[]{RaftPartitionGroupConfig.class}).register(new Class[]{RaftStorageConfig.class}).build();
        }

        @Override
        public ManagedPartitionGroup newPartitionGroup(RaftPartitionGroupConfig config) {
            return new RaftPartitionGroup(config);
        }
    }
}

