/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.log;

import io.atomix.raft.protocol.PersistedRaftRecord;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.IndexedRaftLogEntryImpl;
import io.atomix.raft.storage.log.RaftLogBuilder;
import io.atomix.raft.storage.log.RaftLogCommittedReader;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.atomix.raft.storage.log.RaftLogReader;
import io.atomix.raft.storage.log.RaftLogUncommittedReader;
import io.atomix.raft.storage.log.entry.RaftLogEntry;
import io.atomix.raft.storage.serializer.RaftEntrySBESerializer;
import io.atomix.raft.storage.serializer.RaftEntrySerializer;
import io.camunda.zeebe.journal.Journal;
import io.camunda.zeebe.journal.JournalRecord;
import java.io.Closeable;
import org.agrona.CloseHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class RaftLog
implements Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(RaftLog.class);
    private final RaftEntrySerializer serializer = new RaftEntrySBESerializer();
    private final Journal journal;
    private final RaftLogFlusher flusher;
    private IndexedRaftLogEntry lastAppendedEntry;
    private volatile long commitIndex;

    RaftLog(Journal journal, RaftLogFlusher flusher) {
        this.journal = journal;
        this.flusher = flusher;
    }

    public static RaftLogBuilder builder() {
        return new RaftLogBuilder();
    }

    public RaftLogReader openUncommittedReader() {
        return new RaftLogUncommittedReader(this.journal.openReader());
    }

    public RaftLogReader openCommittedReader() {
        return new RaftLogCommittedReader(this, new RaftLogUncommittedReader(this.journal.openReader()));
    }

    public boolean isOpen() {
        return this.journal.isOpen();
    }

    public boolean deleteUntil(long index) {
        return this.journal.deleteUntil(index);
    }

    public long getCommitIndex() {
        return this.commitIndex;
    }

    public void setCommitIndex(long index) {
        this.commitIndex = index;
    }

    public boolean flushesDirectly() {
        return this.flusher.isDirect();
    }

    public long getFirstIndex() {
        return this.journal.getFirstIndex();
    }

    public long getLastIndex() {
        return this.journal.getLastIndex();
    }

    public IndexedRaftLogEntry getLastEntry() {
        if (this.lastAppendedEntry == null) {
            this.readLastEntry();
        }
        return this.lastAppendedEntry;
    }

    private void readLastEntry() {
        try (RaftLogReader reader = this.openUncommittedReader();){
            reader.seekToLast();
            if (reader.hasNext()) {
                this.lastAppendedEntry = (IndexedRaftLogEntry)reader.next();
            }
        }
    }

    public boolean isEmpty() {
        return this.journal.isEmpty();
    }

    public IndexedRaftLogEntry append(RaftLogEntry entry) {
        JournalRecord journalRecord = this.journal.append(entry.getLowestAsqn().orElse(-1L).longValue(), entry.entry().toSerializable(entry.term(), this.serializer));
        this.lastAppendedEntry = new IndexedRaftLogEntryImpl(entry.term(), entry.entry(), journalRecord);
        return this.lastAppendedEntry;
    }

    public IndexedRaftLogEntry append(PersistedRaftRecord entry) {
        this.journal.append((JournalRecord)entry);
        RaftLogEntry raftEntry = this.serializer.readRaftLogEntry(entry.data());
        this.lastAppendedEntry = new IndexedRaftLogEntryImpl(entry.term(), raftEntry.entry(), entry);
        return this.lastAppendedEntry;
    }

    public void reset(long index) {
        this.journal.reset(index);
        this.lastAppendedEntry = null;
    }

    public void deleteAfter(long index) {
        if (index < this.commitIndex) {
            throw new IllegalStateException(String.format("Expected to delete index after %d, but it is lower than the commit index %d. Deleting committed entries can lead to inconsistencies and is prohibited.", index, this.commitIndex));
        }
        this.journal.deleteAfter(index);
        this.lastAppendedEntry = null;
        this.flush();
    }

    public void flush() {
        this.flusher.flush(this.journal);
    }

    public void forceFlush() {
        RaftLogFlusher.Factory.DIRECT.flush(this.journal);
    }

    @Override
    public void close() {
        CloseHelper.closeAll(error -> LOGGER.warn("Unexpected error while closing the Raft log", error), (AutoCloseable[])new AutoCloseable[]{this.journal, this.flusher});
    }

    public String toString() {
        return "RaftLog{journal=" + this.journal + ", serializer=" + this.serializer + ", lastAppendedEntry=" + this.lastAppendedEntry + ", commitIndex=" + this.commitIndex + "}";
    }
}

