/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.partition;

import com.esotericsoftware.kryo.serializers.FieldSerializer;
import io.atomix.raft.storage.log.RaftLogFlusher;
import io.camunda.zeebe.snapshots.ReceivableSnapshotStoreFactory;

public class RaftStorageConfig {
    private static final String DATA_PREFIX = ".data";
    private static final int DEFAULT_MAX_SEGMENT_SIZE = 0x2000000;
    private static final RaftLogFlusher.Factory DEFAULT_FLUSHER_FACTORY = RaftLogFlusher.Factory::direct;
    private static final long DEFAULT_FREE_DISK_SPACE = 0x40000000L;
    private static final int DEFAULT_JOURNAL_INDEX_DENSITY = 100;
    private static final boolean DEFAULT_PREALLOCATE_SEGMENT_FILES = true;
    private String directory;
    private long segmentSize = 0x2000000L;
    private RaftLogFlusher.Factory flusherFactory = DEFAULT_FLUSHER_FACTORY;
    private long freeDiskSpace = 0x40000000L;
    private int journalIndexDensity = 100;
    private boolean preallocateSegmentFiles = true;
    @FieldSerializer.Optional(value="SnapshotStoreFactory")
    private ReceivableSnapshotStoreFactory persistedSnapshotStoreFactory;

    public String getDirectory(String groupName) {
        return this.directory != null ? this.directory : System.getProperty("atomix.data", DATA_PREFIX) + "/" + groupName;
    }

    public long getSegmentSize() {
        return this.segmentSize;
    }

    public RaftStorageConfig setSegmentSize(long segmentSizeBytes) {
        this.segmentSize = segmentSizeBytes;
        return this;
    }

    public RaftLogFlusher.Factory flusherFactory() {
        return this.flusherFactory;
    }

    public RaftStorageConfig setFlusherFactory(RaftLogFlusher.Factory flusherFactory) {
        this.flusherFactory = flusherFactory;
        return this;
    }

    public RaftStorageConfig setDirectory(String directory) {
        this.directory = directory;
        return this;
    }

    public ReceivableSnapshotStoreFactory getPersistedSnapshotStoreFactory() {
        return this.persistedSnapshotStoreFactory;
    }

    public RaftStorageConfig setPersistedSnapshotStoreFactory(ReceivableSnapshotStoreFactory persistedSnapshotStoreFactory) {
        this.persistedSnapshotStoreFactory = persistedSnapshotStoreFactory;
        return this;
    }

    public long getFreeDiskSpace() {
        return this.freeDiskSpace;
    }

    public RaftStorageConfig setFreeDiskSpace(long freeDiskSpace) {
        this.freeDiskSpace = freeDiskSpace;
        return this;
    }

    public int getJournalIndexDensity() {
        return this.journalIndexDensity;
    }

    public RaftStorageConfig setJournalIndexDensity(int journalIndexDensity) {
        this.journalIndexDensity = journalIndexDensity;
        return this;
    }

    public boolean isPreallocateSegmentFiles() {
        return this.preallocateSegmentFiles;
    }

    public void setPreallocateSegmentFiles(boolean preallocateSegmentFiles) {
        this.preallocateSegmentFiles = preallocateSegmentFiles;
    }

    public String toString() {
        return "RaftStorageConfig{directory='" + this.directory + "', segmentSize=" + this.segmentSize + ", flushExplicitly=" + this.flusherFactory + ", freeDiskSpace=" + this.freeDiskSpace + ", journalIndexDensity=" + this.journalIndexDensity + ", preallocateSegmentFiles=" + this.preallocateSegmentFiles + ", persistedSnapshotStoreFactory=" + this.persistedSnapshotStoreFactory + "}";
    }
}

