/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.cluster.impl;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.cluster.impl.DefaultRaftMember;
import io.atomix.raft.cluster.impl.RaftClusterContext;
import io.atomix.raft.storage.log.IndexedRaftLogEntry;
import io.atomix.raft.storage.log.RaftLog;
import io.atomix.raft.storage.log.RaftLogReader;
import io.camunda.zeebe.snapshots.SnapshotChunkReader;
import java.nio.ByteBuffer;
import org.apache.commons.math3.stat.descriptive.DescriptiveStatistics;
import org.slf4j.LoggerFactory;

public final class RaftMemberContext {
    private static final int APPEND_WINDOW_SIZE = 8;
    private final DefaultRaftMember member;
    private final DescriptiveStatistics timeStats = new DescriptiveStatistics(8);
    private final int maxAppendsPerMember;
    private long term;
    private long configIndex;
    private long snapshotIndex;
    private long nextSnapshotIndex;
    private ByteBuffer nextSnapshotChunk;
    private long matchIndex;
    private long heartbeatTime;
    private long responseTime;
    private int inFlightAppendCount;
    private boolean appendSucceeded;
    private long appendTime;
    private boolean configuring;
    private boolean installing;
    private int failures;
    private long failureTime;
    private volatile RaftLogReader reader;
    private SnapshotChunkReader snapshotChunkReader;
    private IndexedRaftLogEntry currentEntry;

    RaftMemberContext(DefaultRaftMember member, RaftClusterContext cluster, int maxAppendsPerMember) {
        this.member = ((DefaultRaftMember)Preconditions.checkNotNull((Object)member, (Object)"member cannot be null")).setCluster(cluster);
        this.maxAppendsPerMember = maxAppendsPerMember;
    }

    public void resetState(RaftLog log) {
        this.snapshotIndex = 0L;
        this.nextSnapshotIndex = 0L;
        this.nextSnapshotChunk = null;
        this.matchIndex = 0L;
        this.heartbeatTime = 0L;
        this.responseTime = 0L;
        this.inFlightAppendCount = 0;
        this.timeStats.clear();
        this.configuring = false;
        this.installing = false;
        this.appendSucceeded = false;
        this.failures = 0;
        this.failureTime = 0L;
        if (this.reader != null) {
            this.closeReader();
            this.openReader(log);
        }
    }

    private void closeReader() {
        if (this.reader != null) {
            this.reader.close();
            this.reader = null;
        }
    }

    public boolean hasReplicationContext() {
        return this.reader != null;
    }

    public void openReplicationContext(RaftLog log) {
        this.resetState(log);
        this.openReader(log);
    }

    public void closeReplicationContext() {
        this.closeReader();
    }

    private void openReader(RaftLog log) {
        switch (this.member.getType()) {
            case PASSIVE: {
                this.reader = log.openCommittedReader();
                this.resetReaderAtEndOfLog(this.reader);
                break;
            }
            case PROMOTABLE: 
            case ACTIVE: {
                this.reader = log.openUncommittedReader();
                this.resetReaderAtEndOfLog(this.reader);
                break;
            }
            default: {
                LoggerFactory.getLogger(RaftMemberContext.class).error("ResetState: No case for Member type {}", (Object)this.member.getType());
            }
        }
    }

    private void resetReaderAtEndOfLog(RaftLogReader reader) {
        reader.seekToLast();
        if (reader.hasNext()) {
            this.currentEntry = (IndexedRaftLogEntry)reader.next();
        }
    }

    public boolean canAppend() {
        return this.inFlightAppendCount == 0 || this.appendSucceeded && this.inFlightAppendCount < this.maxAppendsPerMember && (double)System.currentTimeMillis() - this.timeStats.getMean() / (double)this.maxAppendsPerMember >= (double)this.appendTime;
    }

    public boolean canHeartbeat() {
        return this.inFlightAppendCount == 0;
    }

    public void appendSucceeded() {
        this.appendSucceeded(true);
    }

    private void appendSucceeded(boolean succeeded) {
        this.appendSucceeded = succeeded;
    }

    public void appendFailed() {
        this.appendSucceeded(false);
    }

    public void startAppend() {
        ++this.inFlightAppendCount;
        this.appendTime = System.currentTimeMillis();
    }

    public void completeAppend() {
        --this.inFlightAppendCount;
    }

    public void completeAppend(long time) {
        --this.inFlightAppendCount;
        this.timeStats.addValue((double)time);
    }

    public boolean canConfigure() {
        return !this.configuring;
    }

    public void startConfigure() {
        this.configuring = true;
    }

    public void completeConfigure() {
        this.configuring = false;
    }

    public boolean canInstall() {
        return !this.installing;
    }

    public void startInstall() {
        this.installing = true;
    }

    public void completeInstall() {
        this.installing = false;
    }

    public int incrementFailureCount() {
        if (this.failures++ == 0) {
            this.failureTime = System.currentTimeMillis();
        }
        return this.failures;
    }

    public void resetFailureCount() {
        this.failures = 0;
        this.failureTime = 0L;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("member", (Object)this.member.memberId()).add("term", this.term).add("configIndex", this.configIndex).add("snapshotIndex", this.snapshotIndex).add("nextSnapshotIndex", this.nextSnapshotIndex).add("nextSnapshotChunk", (Object)this.nextSnapshotChunk).add("matchIndex", this.matchIndex).add("heartbeatTime", this.heartbeatTime).add("appending", this.inFlightAppendCount).add("appendSucceeded", this.appendSucceeded).add("appendTime", this.appendTime).add("configuring", this.configuring).add("installing", this.installing).add("failures", this.failures).toString();
    }

    public long getConfigIndex() {
        return this.configIndex;
    }

    public void setConfigIndex(long configIndex) {
        this.configIndex = configIndex;
    }

    public long getConfigTerm() {
        return this.term;
    }

    public void setConfigTerm(long term) {
        this.term = term;
    }

    public int getFailureCount() {
        return this.failures;
    }

    public long getFailureTime() {
        return this.failureTime;
    }

    public long getHeartbeatTime() {
        return this.heartbeatTime;
    }

    public void setHeartbeatTime(long heartbeatTime) {
        this.heartbeatTime = Math.max(this.heartbeatTime, heartbeatTime);
    }

    public long getMatchIndex() {
        return this.matchIndex;
    }

    public void setMatchIndex(long matchIndex) {
        Preconditions.checkArgument((matchIndex >= 0L ? 1 : 0) != 0, (Object)"matchIndex must be positive");
        this.matchIndex = matchIndex;
    }

    public DefaultRaftMember getMember() {
        return this.member;
    }

    public long getNextSnapshotIndex() {
        return this.nextSnapshotIndex;
    }

    public void setNextSnapshotIndex(long nextSnapshotIndex) {
        this.nextSnapshotIndex = nextSnapshotIndex;
    }

    public ByteBuffer getNextSnapshotChunk() {
        return this.nextSnapshotChunk;
    }

    public void setNextSnapshotChunk(ByteBuffer nextSnapshotChunk) {
        this.nextSnapshotChunk = nextSnapshotChunk;
    }

    public long getResponseTime() {
        return this.responseTime;
    }

    public void setResponseTime(long responseTime) {
        this.responseTime = Math.max(this.responseTime, responseTime);
    }

    public long getSnapshotIndex() {
        return this.snapshotIndex;
    }

    public void setSnapshotIndex(long snapshotIndex) {
        this.snapshotIndex = snapshotIndex;
    }

    public SnapshotChunkReader getSnapshotChunkReader() {
        return this.snapshotChunkReader;
    }

    public void setSnapshotChunkReader(SnapshotChunkReader snapshotChunkReader) {
        this.snapshotChunkReader = snapshotChunkReader;
    }

    public boolean hasNextEntry() {
        return this.reader.hasNext();
    }

    public IndexedRaftLogEntry nextEntry() {
        this.currentEntry = (IndexedRaftLogEntry)this.reader.next();
        return this.currentEntry;
    }

    public IndexedRaftLogEntry getCurrentEntry() {
        return this.currentEntry;
    }

    public long getCurrentIndex() {
        return this.currentEntry != null ? this.currentEntry.index() : 0L;
    }

    public void reset(long index) {
        long nextIndex = this.reader.seek(index - 1L);
        this.currentEntry = nextIndex == index - 1L ? (IndexedRaftLogEntry)this.reader.next() : null;
    }
}

