/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AppendRequest;
import io.atomix.raft.protocol.AppendResponse;
import io.atomix.raft.protocol.ConfigureRequest;
import io.atomix.raft.protocol.ConfigureResponse;
import io.atomix.raft.protocol.InstallRequest;
import io.atomix.raft.protocol.InstallResponse;
import io.atomix.raft.protocol.JoinRequest;
import io.atomix.raft.protocol.JoinResponse;
import io.atomix.raft.protocol.PollRequest;
import io.atomix.raft.protocol.PollResponse;
import io.atomix.raft.protocol.ReconfigureRequest;
import io.atomix.raft.protocol.ReconfigureResponse;
import io.atomix.raft.protocol.TransferRequest;
import io.atomix.raft.protocol.TransferResponse;
import io.atomix.raft.protocol.VersionedAppendRequest;
import io.atomix.raft.protocol.VoteRequest;
import io.atomix.raft.protocol.VoteResponse;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;

public interface RaftServerProtocol {
    public CompletableFuture<ConfigureResponse> configure(MemberId var1, ConfigureRequest var2);

    public CompletableFuture<ReconfigureResponse> reconfigure(MemberId var1, ReconfigureRequest var2);

    public CompletableFuture<JoinResponse> join(MemberId var1, JoinRequest var2);

    public CompletableFuture<InstallResponse> install(MemberId var1, InstallRequest var2);

    public CompletableFuture<TransferResponse> transfer(MemberId var1, TransferRequest var2);

    public CompletableFuture<PollResponse> poll(MemberId var1, PollRequest var2);

    public CompletableFuture<VoteResponse> vote(MemberId var1, VoteRequest var2);

    public CompletableFuture<AppendResponse> append(MemberId var1, AppendRequest var2);

    public CompletableFuture<AppendResponse> append(MemberId var1, VersionedAppendRequest var2);

    public void registerTransferHandler(Function<TransferRequest, CompletableFuture<TransferResponse>> var1);

    public void unregisterTransferHandler();

    public void registerConfigureHandler(Function<ConfigureRequest, CompletableFuture<ConfigureResponse>> var1);

    public void unregisterConfigureHandler();

    public void registerReconfigureHandler(Function<ReconfigureRequest, CompletableFuture<ReconfigureResponse>> var1);

    public void unregisterReconfigureHandler();

    public void registerJoinHandler(Function<JoinRequest, CompletableFuture<JoinResponse>> var1);

    public void unregisterJoinHandler();

    public void registerInstallHandler(Function<InstallRequest, CompletableFuture<InstallResponse>> var1);

    public void unregisterInstallHandler();

    public void registerPollHandler(Function<PollRequest, CompletableFuture<PollResponse>> var1);

    public void unregisterPollHandler();

    public void registerVoteHandler(Function<VoteRequest, CompletableFuture<VoteResponse>> var1);

    public void unregisterVoteHandler();

    public void registerAppendV1Handler(Function<AppendRequest, CompletableFuture<AppendResponse>> var1);

    public void registerAppendV2Handler(Function<VersionedAppendRequest, CompletableFuture<AppendResponse>> var1);

    public void unregisterAppendHandler();
}

