/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.system;

import com.google.common.base.Preconditions;
import io.atomix.raft.cluster.RaftMember;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public record Configuration(long index, long term, long time, Collection<RaftMember> newMembers, Collection<RaftMember> oldMembers) {
    public Configuration {
        Preconditions.checkArgument((time > 0L ? 1 : 0) != 0, (Object)"time must be positive");
        Preconditions.checkNotNull(newMembers, (Object)"members cannot be null");
        Preconditions.checkNotNull(oldMembers, (Object)"oldMembers cannot be null");
    }

    public Configuration(long index, long term, long time, Collection<RaftMember> members) {
        this(index, term, time, members, Collections.emptyList());
    }

    public boolean requiresJointConsensus() {
        return !this.oldMembers.isEmpty();
    }

    public Set<RaftMember> allMembers() {
        HashSet<RaftMember> all = new HashSet<RaftMember>(this.oldMembers.size() + this.newMembers.size());
        all.addAll(this.newMembers);
        all.addAll(this.oldMembers);
        return all;
    }
}

