/* Generated SBE (Simple Binary Encoding) message codec. */
package io.atomix.raft.storage.serializer;

import org.agrona.MutableDirectBuffer;
import org.agrona.DirectBuffer;
import org.agrona.sbe.*;

@SuppressWarnings("all")
public final class ConfigurationEncoder implements MessageEncoderFlyweight
{
    public static final int BLOCK_LENGTH = 24;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 2;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final java.nio.ByteOrder BYTE_ORDER = java.nio.ByteOrder.LITTLE_ENDIAN;

    private final ConfigurationEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int initialOffset;
    private int offset;
    private int limit;

    public int sbeBlockLength()
    {
        return BLOCK_LENGTH;
    }

    public int sbeTemplateId()
    {
        return TEMPLATE_ID;
    }

    public int sbeSchemaId()
    {
        return SCHEMA_ID;
    }

    public int sbeSchemaVersion()
    {
        return SCHEMA_VERSION;
    }

    public String sbeSemanticType()
    {
        return "";
    }

    public MutableDirectBuffer buffer()
    {
        return buffer;
    }

    public int initialOffset()
    {
        return initialOffset;
    }

    public int offset()
    {
        return offset;
    }

    public ConfigurationEncoder wrap(final MutableDirectBuffer buffer, final int offset)
    {
        if (buffer != this.buffer)
        {
            this.buffer = buffer;
        }
        this.initialOffset = offset;
        this.offset = offset;
        limit(offset + BLOCK_LENGTH);

        return this;
    }

    public ConfigurationEncoder wrapAndApplyHeader(
        final MutableDirectBuffer buffer, final int offset, final MessageHeaderEncoder headerEncoder)
    {
        headerEncoder
            .wrap(buffer, offset)
            .blockLength(BLOCK_LENGTH)
            .templateId(TEMPLATE_ID)
            .schemaId(SCHEMA_ID)
            .version(SCHEMA_VERSION);

        return wrap(buffer, offset + MessageHeaderEncoder.ENCODED_LENGTH);
    }

    public int encodedLength()
    {
        return limit - offset;
    }

    public int limit()
    {
        return limit;
    }

    public void limit(final int limit)
    {
        this.limit = limit;
    }

    public static int indexId()
    {
        return 0;
    }

    public static int indexSinceVersion()
    {
        return 0;
    }

    public static int indexEncodingOffset()
    {
        return 0;
    }

    public static int indexEncodingLength()
    {
        return 8;
    }

    public static String indexMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long indexNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long indexMinValue()
    {
        return 0x0L;
    }

    public static long indexMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public ConfigurationEncoder index(final long value)
    {
        buffer.putLong(offset + 0, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int termId()
    {
        return 1;
    }

    public static int termSinceVersion()
    {
        return 0;
    }

    public static int termEncodingOffset()
    {
        return 8;
    }

    public static int termEncodingLength()
    {
        return 8;
    }

    public static String termMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long termNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long termMinValue()
    {
        return 0x0L;
    }

    public static long termMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public ConfigurationEncoder term(final long value)
    {
        buffer.putLong(offset + 8, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    public static int timestampId()
    {
        return 2;
    }

    public static int timestampSinceVersion()
    {
        return 0;
    }

    public static int timestampEncodingOffset()
    {
        return 16;
    }

    public static int timestampEncodingLength()
    {
        return 8;
    }

    public static String timestampMetaAttribute(final MetaAttribute metaAttribute)
    {
        if (MetaAttribute.PRESENCE == metaAttribute)
        {
            return "required";
        }

        return "";
    }

    public static long timestampNullValue()
    {
        return 0xffffffffffffffffL;
    }

    public static long timestampMinValue()
    {
        return 0x0L;
    }

    public static long timestampMaxValue()
    {
        return 0xfffffffffffffffeL;
    }

    public ConfigurationEncoder timestamp(final long value)
    {
        buffer.putLong(offset + 16, value, java.nio.ByteOrder.LITTLE_ENDIAN);
        return this;
    }


    private final NewMembersEncoder newMembers = new NewMembersEncoder(this);

    public static long newMembersId()
    {
        return 3;
    }

    public NewMembersEncoder newMembersCount(final int count)
    {
        newMembers.wrap(buffer, count);
        return newMembers;
    }

    public static final class NewMembersEncoder
    {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NewMembersEncoder(final ConfigurationEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 254)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)9, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NewMembersEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putByte(initialLimit + 2, (byte)count);

            return count;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 9;
        }

        public static int typeId()
        {
            return 1;
        }

        public static int typeSinceVersion()
        {
            return 0;
        }

        public static int typeEncodingOffset()
        {
            return 0;
        }

        public static int typeEncodingLength()
        {
            return 1;
        }

        public static String typeMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public NewMembersEncoder type(final MemberType value)
        {
            buffer.putByte(offset + 0, (byte)value.value());
            return this;
        }

        public static int updatedId()
        {
            return 2;
        }

        public static int updatedSinceVersion()
        {
            return 0;
        }

        public static int updatedEncodingOffset()
        {
            return 1;
        }

        public static int updatedEncodingLength()
        {
            return 8;
        }

        public static String updatedMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long updatedNullValue()
        {
            return -9223372036854775808L;
        }

        public static long updatedMinValue()
        {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue()
        {
            return 9223372036854775807L;
        }

        public NewMembersEncoder updated(final long value)
        {
            buffer.putLong(offset + 1, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int memberIdId()
        {
            return 3;
        }

        public static String memberIdCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int memberIdHeaderLength()
        {
            return 4;
        }

        public NewMembersEncoder putMemberId(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public NewMembersEncoder putMemberId(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public NewMembersEncoder memberId(final String value)
        {
            final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(java.nio.charset.StandardCharsets.UTF_8);

            final int length = bytes.length;
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, bytes, 0, length);

            return this;
        }
    }

    private final OldMembersEncoder oldMembers = new OldMembersEncoder(this);

    public static long oldMembersId()
    {
        return 4;
    }

    public OldMembersEncoder oldMembersCount(final int count)
    {
        oldMembers.wrap(buffer, count);
        return oldMembers;
    }

    public static final class OldMembersEncoder
    {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        OldMembersEncoder(final ConfigurationEncoder parentMessage)
        {
            this.parentMessage = parentMessage;
        }

        public void wrap(final MutableDirectBuffer buffer, final int count)
        {
            if (count < 0 || count > 254)
            {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }

            if (buffer != this.buffer)
            {
                this.buffer = buffer;
            }

            index = 0;
            this.count = count;
            final int limit = parentMessage.limit();
            initialLimit = limit;
            parentMessage.limit(limit + HEADER_SIZE);
            buffer.putShort(limit + 0, (short)9, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putByte(limit + 2, (byte)count);
        }

        public OldMembersEncoder next()
        {
            if (index >= count)
            {
                throw new java.util.NoSuchElementException();
            }

            offset = parentMessage.limit();
            parentMessage.limit(offset + sbeBlockLength());
            ++index;

            return this;
        }

        public int resetCountToIndex()
        {
            count = index;
            buffer.putByte(initialLimit + 2, (byte)count);

            return count;
        }

        public static short countMinValue()
        {
            return (short)0;
        }

        public static short countMaxValue()
        {
            return (short)254;
        }

        public static int sbeHeaderSize()
        {
            return HEADER_SIZE;
        }

        public static int sbeBlockLength()
        {
            return 9;
        }

        public static int typeId()
        {
            return 1;
        }

        public static int typeSinceVersion()
        {
            return 0;
        }

        public static int typeEncodingOffset()
        {
            return 0;
        }

        public static int typeEncodingLength()
        {
            return 1;
        }

        public static String typeMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public OldMembersEncoder type(final MemberType value)
        {
            buffer.putByte(offset + 0, (byte)value.value());
            return this;
        }

        public static int updatedId()
        {
            return 2;
        }

        public static int updatedSinceVersion()
        {
            return 0;
        }

        public static int updatedEncodingOffset()
        {
            return 1;
        }

        public static int updatedEncodingLength()
        {
            return 8;
        }

        public static String updatedMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static long updatedNullValue()
        {
            return -9223372036854775808L;
        }

        public static long updatedMinValue()
        {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue()
        {
            return 9223372036854775807L;
        }

        public OldMembersEncoder updated(final long value)
        {
            buffer.putLong(offset + 1, value, java.nio.ByteOrder.LITTLE_ENDIAN);
            return this;
        }


        public static int memberIdId()
        {
            return 3;
        }

        public static String memberIdCharacterEncoding()
        {
            return java.nio.charset.StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(final MetaAttribute metaAttribute)
        {
            if (MetaAttribute.PRESENCE == metaAttribute)
            {
                return "required";
            }

            return "";
        }

        public static int memberIdHeaderLength()
        {
            return 4;
        }

        public OldMembersEncoder putMemberId(final DirectBuffer src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public OldMembersEncoder putMemberId(final byte[] src, final int srcOffset, final int length)
        {
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, src, srcOffset, length);

            return this;
        }

        public OldMembersEncoder memberId(final String value)
        {
            final byte[] bytes = (null == value || value.isEmpty()) ? org.agrona.collections.ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(java.nio.charset.StandardCharsets.UTF_8);

            final int length = bytes.length;
            if (length > 2147483647)
            {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }

            final int headerLength = 4;
            final int limit = parentMessage.limit();
            parentMessage.limit(limit + headerLength + length);
            buffer.putInt(limit, length, java.nio.ByteOrder.LITTLE_ENDIAN);
            buffer.putBytes(limit + headerLength, bytes, 0, length);

            return this;
        }
    }

    public String toString()
    {
        if (null == buffer)
        {
            return "";
        }

        return appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(final StringBuilder builder)
    {
        if (null == buffer)
        {
            return builder;
        }

        final ConfigurationDecoder decoder = new ConfigurationDecoder();
        decoder.wrap(buffer, initialOffset, BLOCK_LENGTH, SCHEMA_VERSION);

        return decoder.appendTo(builder);
    }
}
