/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.cluster.RaftMember;
import io.atomix.raft.protocol.AbstractRaftRequest;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;

public class ReconfigureRequest
extends AbstractRaftRequest {
    private final long index;
    private final long term;
    private final Collection<RaftMember> members;

    public ReconfigureRequest(Collection<RaftMember> members, long index, long term) {
        this.members = members;
        this.index = index;
        this.term = term;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Collection<RaftMember> members() {
        return this.members;
    }

    public long index() {
        return this.index;
    }

    public long term() {
        return this.term;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.index, this.members);
    }

    public boolean equals(Object object) {
        if (object instanceof ReconfigureRequest) {
            ReconfigureRequest request = (ReconfigureRequest)object;
            return request.index == this.index && request.term == this.term && request.members.equals(this.members);
        }
        return false;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("index", this.index).add("term", this.term).add("members", this.members).toString();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, ReconfigureRequest> {
        private Set<RaftMember> members;
        private long index = -1L;
        private long term = -1L;

        public Builder withMembers(Collection<RaftMember> members) {
            Preconditions.checkNotNull(members, (Object)"members cannot be null");
            this.members = new HashSet<RaftMember>(members);
            return this;
        }

        public Builder withMember(RaftMember member) {
            Preconditions.checkNotNull((Object)member, (Object)"member cannot be null");
            this.members.remove(member);
            this.members.add(member);
            return this;
        }

        public Builder withIndex(long index) {
            Preconditions.checkArgument((index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            this.index = index;
            return this;
        }

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public ReconfigureRequest build() {
            this.validate();
            return new ReconfigureRequest(this.members, this.index, this.term);
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull(this.members, (Object)"members cannot be null");
            Preconditions.checkArgument((this.index >= 0L ? 1 : 0) != 0, (Object)"index must be positive");
            Preconditions.checkArgument((this.term >= 0L ? 1 : 0) != 0, (Object)"term must be positive");
        }
    }
}

