/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging;

import io.atomix.utils.net.Address;
import java.io.IOException;

public class MessagingException
extends IOException {
    public MessagingException(String message) {
        super(message);
    }

    public MessagingException(String message, Throwable cause) {
        super(message, cause);
    }

    public static class ConnectionClosed
    extends MessagingException {
        public ConnectionClosed(String message) {
            super(message);
        }
    }

    public static class NoSuchMemberException
    extends MessagingException {
        public NoSuchMemberException(Address address) {
            super("Failed to handle message, host %s is not a known cluster member".formatted(address));
        }

        public NoSuchMemberException(String message) {
            super(message);
        }
    }

    public static class ProtocolException
    extends MessagingException {
        public ProtocolException() {
            super("Failed to process message due to invalid message structure");
        }
    }

    public static class RemoteHandlerFailure
    extends MessagingException {
        public RemoteHandlerFailure(String message) {
            super(String.format("Remote handler failed to handle message, cause: %s", message));
        }
    }

    public static class NoRemoteHandler
    extends MessagingException {
        public NoRemoteHandler(String subject) {
            super(String.format("No remote message handler registered for this message, subject %s", subject));
        }
    }
}

