/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import com.google.common.base.Preconditions;
import io.atomix.cluster.messaging.impl.AbstractMessageDecoder;
import io.atomix.cluster.messaging.impl.ProtocolMessage;
import io.atomix.cluster.messaging.impl.ProtocolReply;
import io.atomix.cluster.messaging.impl.ProtocolRequest;
import io.atomix.utils.net.Address;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import java.net.InetAddress;
import java.util.List;

class MessageDecoderV1
extends AbstractMessageDecoder {
    private DecoderState currentState = DecoderState.READ_SENDER_IP;
    private InetAddress senderIp;
    private int senderPort;
    private Address senderAddress;
    private ProtocolMessage.Type type;
    private long messageId;
    private int contentLength;
    private byte[] content;
    private int subjectLength;

    MessageDecoderV1() {
    }

    protected void decode(ChannelHandlerContext context, ByteBuf buffer, List<Object> out) throws Exception {
        block2 : switch (this.currentState.ordinal()) {
            case 2: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                buffer.markReaderIndex();
                byte octetsLength = buffer.readByte();
                if (buffer.readableBytes() < octetsLength) {
                    buffer.resetReaderIndex();
                    return;
                }
                byte[] octets = new byte[octetsLength];
                buffer.readBytes(octets);
                this.senderIp = InetAddress.getByAddress(octets);
                this.currentState = DecoderState.READ_SENDER_PORT;
            }
            case 3: {
                if (buffer.readableBytes() < 4) {
                    return;
                }
                this.senderPort = buffer.readInt();
                this.senderAddress = new Address(this.senderIp.getHostName(), this.senderPort, this.senderIp);
                this.currentState = DecoderState.READ_TYPE;
            }
            case 0: {
                if (buffer.readableBytes() < 1) {
                    return;
                }
                this.type = ProtocolMessage.Type.forId(buffer.readByte());
                this.currentState = DecoderState.READ_MESSAGE_ID;
            }
            case 1: {
                try {
                    this.messageId = MessageDecoderV1.readLong(buffer);
                }
                catch (AbstractMessageDecoder.Escape e) {
                    return;
                }
                this.currentState = DecoderState.READ_CONTENT_LENGTH;
            }
            case 7: {
                try {
                    this.contentLength = MessageDecoderV1.readInt(buffer);
                }
                catch (AbstractMessageDecoder.Escape e) {
                    return;
                }
                this.currentState = DecoderState.READ_CONTENT;
            }
            case 8: {
                if (buffer.readableBytes() < this.contentLength) {
                    return;
                }
                if (this.contentLength > 0) {
                    this.content = new byte[this.contentLength];
                    buffer.readBytes(this.content);
                } else {
                    this.content = EMPTY_PAYLOAD;
                }
                switch (this.type) {
                    case REQUEST: {
                        this.currentState = DecoderState.READ_SUBJECT_LENGTH;
                        break block2;
                    }
                    case REPLY: {
                        this.currentState = DecoderState.READ_STATUS;
                        break block2;
                    }
                }
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
                break;
            }
        }
        block14 : switch (this.type) {
            case REQUEST: {
                ProtocolMessage message;
                switch (this.currentState.ordinal()) {
                    case 4: {
                        if (buffer.readableBytes() < 2) {
                            return;
                        }
                        this.subjectLength = buffer.readShort();
                        this.currentState = DecoderState.READ_SUBJECT;
                    }
                    case 5: {
                        if (buffer.readableBytes() < this.subjectLength) {
                            return;
                        }
                        String subject = MessageDecoderV1.readString(buffer, this.subjectLength);
                        message = new ProtocolRequest(this.messageId, this.senderAddress, subject, this.content);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block14;
                    }
                }
                break;
            }
            case REPLY: {
                ProtocolMessage message;
                switch (this.currentState.ordinal()) {
                    case 6: {
                        if (buffer.readableBytes() < 1) {
                            return;
                        }
                        ProtocolReply.Status status = ProtocolReply.Status.forId(buffer.readByte());
                        message = new ProtocolReply(this.messageId, this.content, status);
                        out.add(message);
                        this.currentState = DecoderState.READ_TYPE;
                        break block14;
                    }
                }
                break;
            }
            default: {
                Preconditions.checkState((boolean)false, (Object)"Must not be here");
            }
        }
    }

    static enum DecoderState {
        READ_TYPE,
        READ_MESSAGE_ID,
        READ_SENDER_IP,
        READ_SENDER_PORT,
        READ_SUBJECT_LENGTH,
        READ_SUBJECT,
        READ_STATUS,
        READ_CONTENT_LENGTH,
        READ_CONTENT;

    }
}

