/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AbstractRaftRequest;
import io.atomix.raft.protocol.ReplicatableJournalRecord;
import java.util.List;

public class VersionedAppendRequest
extends AbstractRaftRequest {
    private static final int CURRENT_VERSION = 2;
    private final int version;
    private final long term;
    private final String leader;
    private final long prevLogIndex;
    private final long prevLogTerm;
    private final List<ReplicatableJournalRecord> entries;
    private final long commitIndex;

    public VersionedAppendRequest(int version, long term, String leader, long prevLogIndex, long prevLogTerm, List<ReplicatableJournalRecord> entries, long commitIndex) {
        this.version = version;
        this.term = term;
        this.leader = leader;
        this.prevLogIndex = prevLogIndex;
        this.prevLogTerm = prevLogTerm;
        this.entries = entries;
        this.commitIndex = commitIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long term() {
        return this.term;
    }

    public MemberId leader() {
        return MemberId.from(this.leader);
    }

    public long prevLogIndex() {
        return this.prevLogIndex;
    }

    public long prevLogTerm() {
        return this.prevLogTerm;
    }

    public List<ReplicatableJournalRecord> entries() {
        return this.entries;
    }

    public long commitIndex() {
        return this.commitIndex;
    }

    public int hashCode() {
        int result = this.version;
        result = 31 * result + (int)(this.term ^ this.term >>> 32);
        result = 31 * result + this.leader.hashCode();
        result = 31 * result + (int)(this.prevLogIndex ^ this.prevLogIndex >>> 32);
        result = 31 * result + (int)(this.prevLogTerm ^ this.prevLogTerm >>> 32);
        result = 31 * result + this.entries.hashCode();
        result = 31 * result + (int)(this.commitIndex ^ this.commitIndex >>> 32);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        VersionedAppendRequest that = (VersionedAppendRequest)o;
        if (this.version != that.version) {
            return false;
        }
        if (this.term != that.term) {
            return false;
        }
        if (this.prevLogIndex != that.prevLogIndex) {
            return false;
        }
        if (this.prevLogTerm != that.prevLogTerm) {
            return false;
        }
        if (this.commitIndex != that.commitIndex) {
            return false;
        }
        if (!this.leader.equals(that.leader)) {
            return false;
        }
        return this.entries.equals(that.entries);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("version", this.version).add("term", this.term).add("leader", (Object)this.leader).add("prevLogIndex", this.prevLogIndex).add("prevLogTerm", this.prevLogTerm).add("entries", this.entries.size()).add("commitIndex", this.commitIndex).toString();
    }

    public int version() {
        return this.version;
    }

    @Override
    public MemberId from() {
        return this.leader();
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, VersionedAppendRequest> {
        private static final String NULL_ENTRIES_ERR = "entries cannot be null";
        private long term;
        private String leader;
        private long logIndex;
        private long logTerm;
        private List<ReplicatableJournalRecord> entries;
        private long commitIndex = -1L;
        private int version = 2;

        public Builder withVersion(int version) {
            Preconditions.checkArgument((version > 0 ? 1 : 0) != 0, (Object)"version must be positive");
            this.version = version;
            return this;
        }

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withLeader(MemberId leader) {
            this.leader = (String)((Object)((MemberId)Preconditions.checkNotNull((Object)leader, (Object)"leader cannot be null")).id());
            return this;
        }

        public Builder withPrevLogIndex(long prevLogIndex) {
            Preconditions.checkArgument((prevLogIndex >= 0L ? 1 : 0) != 0, (Object)"prevLogIndex must be positive");
            this.logIndex = prevLogIndex;
            return this;
        }

        public Builder withPrevLogTerm(long prevLogTerm) {
            Preconditions.checkArgument((prevLogTerm >= 0L ? 1 : 0) != 0, (Object)"prevLogTerm must be positive");
            this.logTerm = prevLogTerm;
            return this;
        }

        public Builder withEntries(List<ReplicatableJournalRecord> entries) {
            this.entries = (List)Preconditions.checkNotNull(entries, (Object)NULL_ENTRIES_ERR);
            return this;
        }

        public Builder withCommitIndex(long commitIndex) {
            Preconditions.checkArgument((commitIndex >= 0L ? 1 : 0) != 0, (Object)"commitIndex must be positive");
            this.commitIndex = commitIndex;
            return this;
        }

        public VersionedAppendRequest build() {
            this.validate();
            return new VersionedAppendRequest(this.version, this.term, this.leader, this.logIndex, this.logTerm, this.entries, this.commitIndex);
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            Preconditions.checkNotNull((Object)this.leader, (Object)"leader cannot be null");
            Preconditions.checkArgument((this.logIndex >= 0L ? 1 : 0) != 0, (Object)"prevLogIndex must be positive");
            Preconditions.checkArgument((this.logTerm >= 0L ? 1 : 0) != 0, (Object)"prevLogTerm must be positive");
            Preconditions.checkNotNull(this.entries, (Object)NULL_ENTRIES_ERR);
            Preconditions.checkArgument((this.commitIndex >= 0L ? 1 : 0) != 0, (Object)"commitIndex must be positive");
        }
    }
}

