/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.storage.serializer;

import io.atomix.raft.storage.serializer.BooleanType;
import io.atomix.raft.storage.serializer.ConfigurationDecoder;
import io.atomix.raft.storage.serializer.MemberType;
import io.atomix.raft.storage.serializer.MessageHeaderEncoder;
import io.atomix.raft.storage.serializer.MetaAttribute;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.NoSuchElementException;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.sbe.MessageEncoderFlyweight;

public final class ConfigurationEncoder
implements MessageEncoderFlyweight {
    public static final int BLOCK_LENGTH = 25;
    public static final int TEMPLATE_ID = 5;
    public static final int SCHEMA_ID = 8;
    public static final int SCHEMA_VERSION = 3;
    public static final String SEMANTIC_VERSION = "0.1.0";
    public static final ByteOrder BYTE_ORDER = ByteOrder.LITTLE_ENDIAN;
    private final ConfigurationEncoder parentMessage = this;
    private MutableDirectBuffer buffer;
    private int offset;
    private int limit;
    private final NewMembersEncoder newMembers = new NewMembersEncoder(this);
    private final OldMembersEncoder oldMembers = new OldMembersEncoder(this);

    public int sbeBlockLength() {
        return 25;
    }

    public int sbeTemplateId() {
        return 5;
    }

    public int sbeSchemaId() {
        return 8;
    }

    public int sbeSchemaVersion() {
        return 3;
    }

    public String sbeSemanticType() {
        return "";
    }

    public MutableDirectBuffer buffer() {
        return this.buffer;
    }

    public int offset() {
        return this.offset;
    }

    public ConfigurationEncoder wrap(MutableDirectBuffer buffer, int offset) {
        if (buffer != this.buffer) {
            this.buffer = buffer;
        }
        this.offset = offset;
        this.limit(offset + 25);
        return this;
    }

    public ConfigurationEncoder wrapAndApplyHeader(MutableDirectBuffer buffer, int offset, MessageHeaderEncoder headerEncoder) {
        headerEncoder.wrap(buffer, offset).blockLength(25).templateId(5).schemaId(8).version(3);
        return this.wrap(buffer, offset + 8);
    }

    public int encodedLength() {
        return this.limit - this.offset;
    }

    public int limit() {
        return this.limit;
    }

    public void limit(int limit) {
        this.limit = limit;
    }

    public static int indexId() {
        return 0;
    }

    public static int indexSinceVersion() {
        return 0;
    }

    public static int indexEncodingOffset() {
        return 0;
    }

    public static int indexEncodingLength() {
        return 8;
    }

    public static String indexMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long indexNullValue() {
        return -1L;
    }

    public static long indexMinValue() {
        return 0L;
    }

    public static long indexMaxValue() {
        return -2L;
    }

    public ConfigurationEncoder index(long value) {
        this.buffer.putLong(this.offset + 0, value, BYTE_ORDER);
        return this;
    }

    public static int termId() {
        return 1;
    }

    public static int termSinceVersion() {
        return 0;
    }

    public static int termEncodingOffset() {
        return 8;
    }

    public static int termEncodingLength() {
        return 8;
    }

    public static String termMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long termNullValue() {
        return -1L;
    }

    public static long termMinValue() {
        return 0L;
    }

    public static long termMaxValue() {
        return -2L;
    }

    public ConfigurationEncoder term(long value) {
        this.buffer.putLong(this.offset + 8, value, BYTE_ORDER);
        return this;
    }

    public static int timestampId() {
        return 2;
    }

    public static int timestampSinceVersion() {
        return 0;
    }

    public static int timestampEncodingOffset() {
        return 16;
    }

    public static int timestampEncodingLength() {
        return 8;
    }

    public static String timestampMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public static long timestampNullValue() {
        return -1L;
    }

    public static long timestampMinValue() {
        return 0L;
    }

    public static long timestampMaxValue() {
        return -2L;
    }

    public ConfigurationEncoder timestamp(long value) {
        this.buffer.putLong(this.offset + 16, value, BYTE_ORDER);
        return this;
    }

    public static int forceId() {
        return 5;
    }

    public static int forceSinceVersion() {
        return 3;
    }

    public static int forceEncodingOffset() {
        return 24;
    }

    public static int forceEncodingLength() {
        return 1;
    }

    public static String forceMetaAttribute(MetaAttribute metaAttribute) {
        if (MetaAttribute.PRESENCE == metaAttribute) {
            return "required";
        }
        return "";
    }

    public ConfigurationEncoder force(BooleanType value) {
        this.buffer.putByte(this.offset + 24, (byte)value.value());
        return this;
    }

    public static long newMembersId() {
        return 3L;
    }

    public NewMembersEncoder newMembersCount(int count) {
        this.newMembers.wrap(this.buffer, count);
        return this.newMembers;
    }

    public static long oldMembersId() {
        return 4L;
    }

    public OldMembersEncoder oldMembersCount(int count) {
        this.oldMembers.wrap(this.buffer, count);
        return this.oldMembers;
    }

    public String toString() {
        if (null == this.buffer) {
            return "";
        }
        return this.appendTo(new StringBuilder()).toString();
    }

    public StringBuilder appendTo(StringBuilder builder) {
        if (null == this.buffer) {
            return builder;
        }
        ConfigurationDecoder decoder = new ConfigurationDecoder();
        decoder.wrap((DirectBuffer)this.buffer, this.offset, 25, 3);
        return decoder.appendTo(builder);
    }

    public static final class NewMembersEncoder {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        NewMembersEncoder(ConfigurationEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)9, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public NewMembersEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + NewMembersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public static int typeId() {
            return 1;
        }

        public static int typeSinceVersion() {
            return 0;
        }

        public static int typeEncodingOffset() {
            return 0;
        }

        public static int typeEncodingLength() {
            return 1;
        }

        public static String typeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public NewMembersEncoder type(MemberType value) {
            this.buffer.putByte(this.offset + 0, (byte)value.value());
            return this;
        }

        public static int updatedId() {
            return 2;
        }

        public static int updatedSinceVersion() {
            return 0;
        }

        public static int updatedEncodingOffset() {
            return 1;
        }

        public static int updatedEncodingLength() {
            return 8;
        }

        public static String updatedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long updatedNullValue() {
            return Long.MIN_VALUE;
        }

        public static long updatedMinValue() {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue() {
            return Long.MAX_VALUE;
        }

        public NewMembersEncoder updated(long value) {
            this.buffer.putLong(this.offset + 1, value, BYTE_ORDER);
            return this;
        }

        public static int memberIdId() {
            return 3;
        }

        public static String memberIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdHeaderLength() {
            return 4;
        }

        public NewMembersEncoder putMemberId(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public NewMembersEncoder putMemberId(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public NewMembersEncoder memberId(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }

    public static final class OldMembersEncoder {
        public static final int HEADER_SIZE = 3;
        private final ConfigurationEncoder parentMessage;
        private MutableDirectBuffer buffer;
        private int count;
        private int index;
        private int offset;
        private int initialLimit;

        OldMembersEncoder(ConfigurationEncoder parentMessage) {
            this.parentMessage = parentMessage;
        }

        public void wrap(MutableDirectBuffer buffer, int count) {
            int limit;
            if (count < 0 || count > 254) {
                throw new IllegalArgumentException("count outside allowed range: count=" + count);
            }
            if (buffer != this.buffer) {
                this.buffer = buffer;
            }
            this.index = 0;
            this.count = count;
            this.initialLimit = limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 3);
            buffer.putShort(limit + 0, (short)9, BYTE_ORDER);
            buffer.putByte(limit + 2, (byte)count);
        }

        public OldMembersEncoder next() {
            if (this.index >= this.count) {
                throw new NoSuchElementException();
            }
            this.offset = this.parentMessage.limit();
            this.parentMessage.limit(this.offset + OldMembersEncoder.sbeBlockLength());
            ++this.index;
            return this;
        }

        public int resetCountToIndex() {
            this.count = this.index;
            this.buffer.putByte(this.initialLimit + 2, (byte)this.count);
            return this.count;
        }

        public static short countMinValue() {
            return 0;
        }

        public static short countMaxValue() {
            return 254;
        }

        public static int sbeHeaderSize() {
            return 3;
        }

        public static int sbeBlockLength() {
            return 9;
        }

        public static int typeId() {
            return 1;
        }

        public static int typeSinceVersion() {
            return 0;
        }

        public static int typeEncodingOffset() {
            return 0;
        }

        public static int typeEncodingLength() {
            return 1;
        }

        public static String typeMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public OldMembersEncoder type(MemberType value) {
            this.buffer.putByte(this.offset + 0, (byte)value.value());
            return this;
        }

        public static int updatedId() {
            return 2;
        }

        public static int updatedSinceVersion() {
            return 0;
        }

        public static int updatedEncodingOffset() {
            return 1;
        }

        public static int updatedEncodingLength() {
            return 8;
        }

        public static String updatedMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static long updatedNullValue() {
            return Long.MIN_VALUE;
        }

        public static long updatedMinValue() {
            return -9223372036854775807L;
        }

        public static long updatedMaxValue() {
            return Long.MAX_VALUE;
        }

        public OldMembersEncoder updated(long value) {
            this.buffer.putLong(this.offset + 1, value, BYTE_ORDER);
            return this;
        }

        public static int memberIdId() {
            return 3;
        }

        public static String memberIdCharacterEncoding() {
            return StandardCharsets.UTF_8.name();
        }

        public static String memberIdMetaAttribute(MetaAttribute metaAttribute) {
            if (MetaAttribute.PRESENCE == metaAttribute) {
                return "required";
            }
            return "";
        }

        public static int memberIdHeaderLength() {
            return 4;
        }

        public OldMembersEncoder putMemberId(DirectBuffer src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public OldMembersEncoder putMemberId(byte[] src, int srcOffset, int length) {
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, src, srcOffset, length);
            return this;
        }

        public OldMembersEncoder memberId(String value) {
            byte[] bytes = null == value || value.isEmpty() ? ArrayUtil.EMPTY_BYTE_ARRAY : value.getBytes(StandardCharsets.UTF_8);
            int length = bytes.length;
            if (length > Integer.MAX_VALUE) {
                throw new IllegalStateException("length > maxValue for type: " + length);
            }
            int headerLength = 4;
            int limit = this.parentMessage.limit();
            this.parentMessage.limit(limit + 4 + length);
            this.buffer.putInt(limit, length, BYTE_ORDER);
            this.buffer.putBytes(limit + 4, bytes, 0, length);
            return this;
        }
    }
}

