/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.zeebe;

import io.atomix.raft.storage.log.entry.ApplicationEntry;

@FunctionalInterface
public interface EntryValidator {
    public ValidationResult validateEntry(ApplicationEntry var1, ApplicationEntry var2);

    public static final class NoopEntryValidator
    implements EntryValidator {
        @Override
        public ValidationResult validateEntry(ApplicationEntry lastEntry, ApplicationEntry entry) {
            return ValidationResult.ok();
        }
    }

    public record ValidationResult(boolean success, String errorMessage) {
        public static ValidationResult ok() {
            return Singleton.OK.result;
        }

        public static ValidationResult failure(String errorMessage) {
            return new ValidationResult(false, errorMessage);
        }

        public boolean failed() {
            return !this.success;
        }

        private static enum Singleton {
            OK(new ValidationResult(true, null));

            private final ValidationResult result;

            private Singleton(ValidationResult result) {
                this.result = result;
            }
        }
    }
}

