/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.cluster.messaging.impl;

import io.netty.channel.ChannelFuture;
import io.netty.handler.codec.dns.DnsQuestion;
import io.netty.handler.codec.dns.DnsResponseCode;
import io.netty.resolver.dns.DnsQueryLifecycleObserver;
import io.prometheus.client.Counter;
import java.net.InetSocketAddress;
import java.util.List;

final class NettyDnsMetrics
implements DnsQueryLifecycleObserver {
    private static final Counter ERROR = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().help("Counts how often DNS queries fail with an error")).namespace("zeebe")).subsystem("dns")).name("error")).register();
    private static final Counter FAILED = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().help("Counts how often DNS queries return an unsuccessful answer")).namespace("zeebe")).subsystem("dns")).name("failed")).labelNames(new String[]{"code"})).register();
    private static final Counter WRITTEN = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().help("Counts how often DNS queries are written")).namespace("zeebe")).subsystem("dns")).name("written")).register();
    private static final Counter SUCCESS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().help("Counts how often DNS queries are successful")).namespace("zeebe")).subsystem("dns")).name("success")).register();

    NettyDnsMetrics() {
    }

    public void queryWritten(InetSocketAddress dnsServerAddress, ChannelFuture future) {
        WRITTEN.inc();
    }

    public void queryCancelled(int queriesRemaining) {
    }

    public DnsQueryLifecycleObserver queryRedirected(List<InetSocketAddress> nameServers) {
        return this;
    }

    public DnsQueryLifecycleObserver queryCNAMEd(DnsQuestion cnameQuestion) {
        return this;
    }

    public DnsQueryLifecycleObserver queryNoAnswer(DnsResponseCode code) {
        ((Counter.Child)FAILED.labels(new String[]{code.toString()})).inc();
        return this;
    }

    public void queryFailed(Throwable cause) {
        ERROR.inc();
    }

    public void querySucceed() {
        SUCCESS.inc();
    }
}

