/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.impl;

import io.atomix.raft.ElectionTimer;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ThreadContext;
import java.time.Duration;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RandomizedElectionTimer
implements ElectionTimer {
    private static final Logger LOGGER = LoggerFactory.getLogger(RandomizedElectionTimer.class);
    private Scheduled electionTimer;
    private final Duration electionTimeout;
    private final ThreadContext threadContext;
    private final Random random;
    private final Runnable triggerElection;
    private final Logger log;

    public RandomizedElectionTimer(Duration electionTimeout, ThreadContext threadContext, Random random, Runnable triggerElection, Logger log) {
        this.electionTimeout = electionTimeout;
        this.threadContext = threadContext;
        this.random = random;
        this.triggerElection = triggerElection;
        this.log = log;
    }

    @Override
    public void reset() {
        this.cancel();
        Duration delay = this.electionTimeout.plus(Duration.ofMillis(this.random.nextInt((int)this.electionTimeout.toMillis())));
        this.electionTimer = this.threadContext.schedule(delay, this::onElectionTimeout);
        LOGGER.trace("Election timeout scheduled for {}", (Object)delay);
    }

    @Override
    public void cancel() {
        if (this.electionTimer != null) {
            this.electionTimer.cancel();
            this.electionTimer = null;
        }
    }

    private void onElectionTimeout() {
        this.electionTimer = this.threadContext.schedule(this.electionTimeout, () -> {
            this.log.debug("Failed to poll a majority of the cluster in {}", (Object)this.electionTimeout);
            this.reset();
        });
        this.triggerElection.run();
    }
}

