/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.metrics;

import io.atomix.raft.metrics.RaftMetrics;
import io.prometheus.client.Counter;
import io.prometheus.client.Gauge;
import io.prometheus.client.Histogram;

public class RaftRoleMetrics
extends RaftMetrics {
    private static final Gauge ROLE = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("role")).help("Shows current role")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private static final Counter HEARTBEAT_MISS = (Counter)((Counter.Builder)((Counter.Builder)((Counter.Builder)((Counter.Builder)Counter.build().namespace("atomix")).name("heartbeat_miss_count")).help("Count of missing heartbeats")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private static final Histogram HEARTBEAT_TIME = (Histogram)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)((Histogram.Builder)Histogram.build().namespace("atomix")).name("heartbeat_time_in_s")).help("Time between heartbeats")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private static final Gauge ELECTION_LATENCY = (Gauge)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)((Gauge.Builder)Gauge.build().namespace("atomix")).name("election_latency_in_ms")).help("Duration for election")).labelNames(new String[]{"partitionGroupName", "partition"})).register();
    private final Gauge.Child role;
    private final Counter.Child heartbeatMiss;
    private final Histogram.Child heartbeatTime;
    private final Gauge.Child electionLatency;

    public RaftRoleMetrics(String partitionName) {
        super(partitionName);
        this.role = (Gauge.Child)ROLE.labels(new String[]{this.partitionGroupName, this.partition});
        this.heartbeatMiss = (Counter.Child)HEARTBEAT_MISS.labels(new String[]{this.partitionGroupName, this.partition});
        this.heartbeatTime = (Histogram.Child)HEARTBEAT_TIME.labels(new String[]{this.partitionGroupName, this.partition});
        this.electionLatency = (Gauge.Child)ELECTION_LATENCY.labels(new String[]{this.partitionGroupName, this.partition});
    }

    public void becomingInactive() {
        this.role.set(0.0);
    }

    public void becomingFollower() {
        this.role.set(1.0);
    }

    public void becomingCandidate() {
        this.role.set(2.0);
    }

    public void becomingLeader() {
        this.role.set(3.0);
    }

    public void countHeartbeatMiss() {
        this.heartbeatMiss.inc();
    }

    public void observeHeartbeatInterval(long milliseconds) {
        this.heartbeatTime.observe((double)((float)milliseconds / 1000.0f));
    }

    public static double getHeartbeatMissCount(String partition) {
        return ((Counter.Child)HEARTBEAT_MISS.labels(new String[]{partition, partition})).get();
    }

    public void setElectionLatency(long latencyMs) {
        this.electionLatency.set((double)latencyMs);
    }
}

