/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.raft.RaftError;
import io.atomix.raft.protocol.AbstractRaftResponse;
import io.atomix.raft.protocol.RaftResponse;
import java.util.Objects;

public class AppendResponse
extends AbstractRaftResponse {
    private final long term;
    private final boolean succeeded;
    private final long lastLogIndex;
    private final long lastSnapshotIndex;
    private final long configurationIndex;

    public AppendResponse(RaftResponse.Status status, RaftError error, long term, boolean succeeded, long lastLogIndex, long lastSnapshotIndex, long configurationIndex) {
        super(status, error);
        this.term = term;
        this.succeeded = succeeded;
        this.lastLogIndex = lastLogIndex;
        this.lastSnapshotIndex = lastSnapshotIndex;
        this.configurationIndex = configurationIndex;
    }

    public static Builder builder() {
        return new Builder();
    }

    public long term() {
        return this.term;
    }

    public boolean succeeded() {
        return this.succeeded;
    }

    public long lastLogIndex() {
        return this.lastLogIndex;
    }

    public long lastSnapshotIndex() {
        return this.lastSnapshotIndex;
    }

    public long configurationIndex() {
        return this.configurationIndex;
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{this.getClass(), this.status, this.term, this.succeeded, this.lastLogIndex, this.lastSnapshotIndex, this.configurationIndex});
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof AppendResponse)) {
            return false;
        }
        AppendResponse response = (AppendResponse)object;
        return response.status == this.status && response.term == this.term && response.succeeded == this.succeeded && response.lastLogIndex == this.lastLogIndex && response.lastSnapshotIndex == this.lastSnapshotIndex && response.configurationIndex == this.configurationIndex;
    }

    @Override
    public String toString() {
        if (this.status == RaftResponse.Status.OK) {
            return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("term", this.term).add("succeeded", this.succeeded).add("lastLogIndex", this.lastLogIndex).add("lastSnapshotIndex", this.lastSnapshotIndex).add("configurationIndex", this.configurationIndex).toString();
        }
        return MoreObjects.toStringHelper((Object)this).add("status", (Object)this.status).add("error", (Object)this.error).toString();
    }

    public static class Builder
    extends AbstractRaftResponse.Builder<Builder, AppendResponse> {
        private long term;
        private boolean succeeded;
        private long lastLogIndex;
        private long lastSnapshotIndex;
        private long configurationIndex;

        public Builder withTerm(long term) {
            Preconditions.checkArgument((term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
            this.term = term;
            return this;
        }

        public Builder withSucceeded(boolean succeeded) {
            this.succeeded = succeeded;
            return this;
        }

        public Builder withLastLogIndex(long lastLogIndex) {
            Preconditions.checkArgument((lastLogIndex >= 0L ? 1 : 0) != 0, (Object)"lastLogIndex must be positive");
            this.lastLogIndex = lastLogIndex;
            return this;
        }

        public Builder withLastSnapshotIndex(long lastSnapshotIndex) {
            Preconditions.checkArgument((lastSnapshotIndex >= 0L ? 1 : 0) != 0, (Object)"lastSnapshotIndex must be positive");
            this.lastSnapshotIndex = lastSnapshotIndex;
            return this;
        }

        public Builder withConfigurationIndex(long configurationIndex) {
            this.configurationIndex = configurationIndex;
            return this;
        }

        public AppendResponse build() {
            this.validate();
            return new AppendResponse(this.status, this.error, this.term, this.succeeded, this.lastLogIndex, this.lastSnapshotIndex, this.configurationIndex);
        }

        @Override
        protected void validate() {
            super.validate();
            if (this.status == RaftResponse.Status.OK) {
                Preconditions.checkArgument((this.term > 0L ? 1 : 0) != 0, (Object)"term must be positive");
                Preconditions.checkArgument((this.lastLogIndex >= 0L ? 1 : 0) != 0, (Object)"lastLogIndex must be positive");
                Preconditions.checkArgument((this.lastSnapshotIndex >= 0L ? 1 : 0) != 0, (Object)"lastSnapshotIndex must be positive");
            }
        }
    }
}

