/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.raft.protocol;

import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import io.atomix.cluster.MemberId;
import io.atomix.raft.protocol.AbstractRaftRequest;
import java.util.Objects;

public class TransferRequest
extends AbstractRaftRequest {
    protected final MemberId member;

    protected TransferRequest(MemberId member) {
        this.member = member;
    }

    public static Builder builder() {
        return new Builder();
    }

    public MemberId member() {
        return this.member;
    }

    public int hashCode() {
        return Objects.hash(this.getClass(), this.member);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || !this.getClass().isAssignableFrom(object.getClass())) {
            return false;
        }
        return ((TransferRequest)object).member.equals(this.member);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("member", (Object)this.member).toString();
    }

    @Override
    public MemberId from() {
        return this.member;
    }

    public static class Builder
    extends AbstractRaftRequest.Builder<Builder, TransferRequest> {
        protected MemberId member;

        public Builder withMember(MemberId member) {
            this.member = (MemberId)Preconditions.checkNotNull((Object)member, (Object)"member cannot be null");
            return this;
        }

        @Override
        protected void validate() {
            super.validate();
            Preconditions.checkNotNull((Object)this.member, (Object)"member cannot be null");
        }

        public TransferRequest build() {
            return new TransferRequest(this.member);
        }
    }
}

