/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.net;

import com.google.common.net.HostAndPort;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.Objects;

public final class Address {
    private static final int DEFAULT_PORT = 5679;
    private final String host;
    private final int port;
    private volatile transient Type type;
    private volatile InetSocketAddress socketAddress;

    public Address(String host, int port) {
        this(host, port, null);
    }

    public Address(String host, int port, InetAddress address) {
        this.host = host;
        this.port = port;
        if (address != null) {
            this.type = address instanceof Inet6Address ? Type.IPV6 : Type.IPV4;
            this.socketAddress = new InetSocketAddress(address, port);
        } else {
            this.socketAddress = InetSocketAddress.createUnresolved(host, port);
        }
    }

    public static Address local() {
        return Address.from(5679);
    }

    public static Address from(String address) {
        try {
            HostAndPort parsedAddress = HostAndPort.fromString((String)address).withDefaultPort(5679);
            return new Address(parsedAddress.getHost(), parsedAddress.getPort());
        }
        catch (IllegalStateException e) {
            return Address.from(5679);
        }
    }

    public static Address from(String host, int port) {
        return new Address(host, port);
    }

    public static Address from(int port) {
        try {
            InetAddress address = Address.getLocalAddress();
            return new Address(address.getHostName(), port);
        }
        catch (UnknownHostException e) {
            throw new IllegalArgumentException("Failed to locate host", e);
        }
    }

    private static InetAddress getLocalAddress() throws UnknownHostException {
        try {
            return InetAddress.getLocalHost();
        }
        catch (Exception ignore) {
            return InetAddress.getByName(null);
        }
    }

    public String host() {
        return this.host;
    }

    public int port() {
        return this.port;
    }

    public InetAddress address() {
        return this.address(false);
    }

    public InetAddress address(boolean resolve) {
        if (resolve || this.socketAddress.isUnresolved()) {
            this.socketAddress = new InetSocketAddress(this.host, this.port);
            return this.socketAddress.getAddress();
        }
        return this.socketAddress.getAddress();
    }

    public InetSocketAddress socketAddress() {
        return this.socketAddress;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Type type() {
        if (this.type == null) {
            Address address = this;
            synchronized (address) {
                if (this.type == null) {
                    this.type = this.address() instanceof Inet6Address ? Type.IPV6 : Type.IPV4;
                }
            }
        }
        return this.type;
    }

    public int hashCode() {
        return Objects.hash(this.host, this.port);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Address that = (Address)obj;
        return this.host.equals(that.host) && this.port == that.port;
    }

    public String toString() {
        String host = this.host();
        int port = this.port();
        if (host.matches("([0-9a-f]{1,4}:){7}([0-9a-f]){1,4}")) {
            return String.format("[%s]:%d", host, port);
        }
        return String.format("%s:%d", host, port);
    }

    public static enum Type {
        IPV4,
        IPV6;

    }
}

