/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.base.Preconditions;
import io.atomix.utils.concurrent.AtomixThread;
import io.atomix.utils.concurrent.Scheduler;
import io.camunda.zeebe.util.CloseableSilently;
import java.util.concurrent.Executor;

public interface ThreadContext
extends CloseableSilently,
Executor,
Scheduler {
    public static ThreadContext currentContext() {
        ThreadContext threadContext;
        Thread thread = Thread.currentThread();
        if (thread instanceof AtomixThread) {
            AtomixThread atomixThread = (AtomixThread)thread;
            threadContext = atomixThread.getContext();
        } else {
            threadContext = null;
        }
        return threadContext;
    }

    default public void checkThread() {
        Preconditions.checkState((ThreadContext.currentContext() == this ? 1 : 0) != 0, (Object)"not on the expected thread");
    }

    @Override
    default public void close() {
    }
}

