/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer.serializers;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class ByteBufferSerializer
extends Serializer<ByteBuffer> {
    public void write(Kryo kryo, Output output, ByteBuffer object) {
        output.writeBoolean(object.isDirect());
        output.writeBoolean(ByteOrder.LITTLE_ENDIAN.equals(object.order()));
        output.writeInt(object.remaining());
        for (int i = object.position(); i < object.limit(); ++i) {
            output.writeByte(object.get(i));
        }
    }

    public ByteBuffer read(Kryo kryo, Input input, Class<? extends ByteBuffer> type) {
        boolean isDirect = input.readBoolean();
        boolean isLittleEndian = input.readBoolean();
        int capacity = input.readInt();
        ByteBuffer buffer = isDirect ? ByteBuffer.allocateDirect(capacity) : ByteBuffer.allocate(capacity);
        if (isLittleEndian) {
            buffer.order(ByteOrder.LITTLE_ENDIAN);
        } else {
            buffer.order(ByteOrder.BIG_ENDIAN);
        }
        for (int i = 0; i < capacity; ++i) {
            buffer.put(i, input.readByte());
        }
        return buffer;
    }
}

