/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.concurrent;

import com.google.common.base.Preconditions;
import io.atomix.utils.concurrent.AtomixThread;
import io.atomix.utils.concurrent.Scheduled;
import io.atomix.utils.concurrent.ScheduledFutureImpl;
import io.atomix.utils.concurrent.ThreadContext;
import io.atomix.utils.concurrent.Threads;
import io.camunda.zeebe.util.error.FatalErrorHandler;
import java.time.Duration;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleThreadContext
implements ThreadContext {
    protected static final Logger LOGGER = LoggerFactory.getLogger(SingleThreadContext.class);
    private static final FatalErrorHandler FATAL_ERROR_HANDLER = FatalErrorHandler.withLogger((Logger)LOGGER);
    private static final Consumer<Throwable> DEFAULT_UNCAUGHT_EXCEPTION_OBSERVER = e -> LOGGER.error("An uncaught exception occurred", e);
    protected final ScheduledExecutorService executor;
    private final Consumer<Throwable> uncaughtExceptionObserver;
    private final Executor wrappedExecutor = new Executor(){

        @Override
        public void execute(Runnable command) {
            try {
                SingleThreadContext.this.executor.execute(command);
            }
            catch (RejectedExecutionException e) {
                LOGGER.warn("Execution of {} was rejected!", (Object)command, (Object)e);
            }
        }
    };

    public SingleThreadContext(String nameFormat) {
        this(Threads.namedThreads(nameFormat, LOGGER));
    }

    public SingleThreadContext(ThreadFactory factory) {
        this(new ScheduledThreadPoolExecutor(1, factory), DEFAULT_UNCAUGHT_EXCEPTION_OBSERVER);
    }

    public SingleThreadContext(ThreadFactory factory, Consumer<Throwable> uncaughtExceptionObserver) {
        this(new ScheduledThreadPoolExecutor(1, factory), uncaughtExceptionObserver);
    }

    protected SingleThreadContext(ScheduledExecutorService executor, Consumer<Throwable> uncaughtExceptionObserver) {
        this(SingleThreadContext.getThread(executor), executor, uncaughtExceptionObserver);
    }

    private SingleThreadContext(Thread thread, ScheduledExecutorService executor, Consumer<Throwable> uncaughtExceptionObserver) {
        this.executor = executor;
        this.uncaughtExceptionObserver = uncaughtExceptionObserver;
        Preconditions.checkState((boolean)(thread instanceof AtomixThread), (Object)"not a Catalyst thread");
        ((AtomixThread)thread).setContext(this);
    }

    protected static AtomixThread getThread(ExecutorService executor) {
        AtomicReference thread = new AtomicReference();
        try {
            executor.submit(() -> thread.set((AtomixThread)Thread.currentThread())).get();
        }
        catch (InterruptedException | ExecutionException e) {
            throw new IllegalStateException("failed to initialize thread state", e);
        }
        return (AtomixThread)thread.get();
    }

    @Override
    public void execute(Runnable command) {
        this.wrappedExecutor.execute(new WrappedRunnable(command));
    }

    @Override
    public Scheduled schedule(Duration delay, Runnable runnable) {
        ScheduledFuture<?> future = this.executor.schedule(new WrappedRunnable(runnable), delay.toMillis(), TimeUnit.MILLISECONDS);
        return new ScheduledFutureImpl(future);
    }

    @Override
    public Scheduled schedule(Duration delay, Duration interval, Runnable runnable) {
        ScheduledFuture<?> future = this.executor.scheduleAtFixedRate(new WrappedRunnable(runnable), delay.toMillis(), interval.toMillis(), TimeUnit.MILLISECONDS);
        return new ScheduledFutureImpl(future);
    }

    @Override
    public void close() {
        this.executor.shutdownNow();
        try {
            this.executor.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    class WrappedRunnable
    implements Runnable {
        private final Runnable command;

        WrappedRunnable(Runnable command) {
            this.command = command;
        }

        @Override
        public void run() {
            try {
                this.command.run();
            }
            catch (Throwable e) {
                FATAL_ERROR_HANDLER.handleError(e);
                SingleThreadContext.this.uncaughtExceptionObserver.accept(e);
                throw e;
            }
        }
    }
}

