/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.ComparisonChain;
import java.util.Arrays;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;
    private final String build;

    private Version(int major, int minor, int patch, String build) {
        Preconditions.checkArgument((major >= 0 ? 1 : 0) != 0, (Object)"major version must be >= 0");
        Preconditions.checkArgument((minor >= 0 ? 1 : 0) != 0, (Object)"minor version must be >= 0");
        Preconditions.checkArgument((patch >= 0 ? 1 : 0) != 0, (Object)"patch version must be >= 0");
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = Build.from(build).toString();
    }

    public static Version from(String version) {
        String[] fields = version.split("[.-]", 4);
        Preconditions.checkArgument((fields.length >= 3 ? 1 : 0) != 0, (Object)String.format("version number is invalid :%s", version));
        return new Version(Integer.parseInt(fields[0]), Integer.parseInt(fields[1]), Integer.parseInt(fields[2]), fields.length == 4 ? fields[3] : null);
    }

    public static Version from(int major, int minor, int patch, String build) {
        return new Version(major, minor, patch, build);
    }

    public String build() {
        return this.build;
    }

    @Override
    public int compareTo(Version that) {
        return ComparisonChain.start().compare(this.major, that.major).compare(this.minor, that.minor).compare(this.patch, that.patch).compare((Comparable)Build.from(this.build), (Comparable)Build.from(that.build)).result();
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.build);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        Version that = (Version)object;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equals(this.build, that.build);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder().append(this.major).append('.').append(this.minor).append('.').append(this.patch);
        String build = Build.from(this.build).toString();
        if (build != null) {
            builder.append('-').append(build);
        }
        return builder.toString();
    }

    private static final class Build
    implements Comparable<Build> {
        private final Type type;
        private final String version;
        private final int[] versionIdentifiers;

        private Build(Type type, int version) {
            this(type, String.valueOf(version), new int[]{version});
        }

        private Build(Type type, String version, int[] versionIdentifiers) {
            this.type = type;
            this.version = version;
            this.versionIdentifiers = versionIdentifiers;
        }

        public static Build from(String build) {
            if (build == null) {
                return new Build(Type.FINAL, 0);
            }
            if (build.equalsIgnoreCase(Type.SNAPSHOT.name())) {
                return new Build(Type.SNAPSHOT, 0);
            }
            for (Type type : Type.values()) {
                if (type.name == null || build.length() < type.name.length() || !build.substring(0, type.name.length()).equalsIgnoreCase(type.name)) continue;
                try {
                    String preReleaseVersion = build.substring(type.name.length());
                    String[] preReleaseSplitVersion = preReleaseVersion.split("[.]");
                    int[] preReleaseVersionIdentifiers = new int[preReleaseSplitVersion.length];
                    for (int i = 0; i < preReleaseVersionIdentifiers.length; ++i) {
                        preReleaseVersionIdentifiers[i] = Integer.parseInt(preReleaseSplitVersion[i]);
                    }
                    return new Build(type, preReleaseVersion, preReleaseVersionIdentifiers);
                }
                catch (NumberFormatException e) {
                    throw new IllegalArgumentException(build + " is not a valid build version string");
                }
            }
            throw new IllegalArgumentException(build + " is not a valid build version string");
        }

        @Override
        public int compareTo(Build that) {
            ComparisonChain comparisonChain = ComparisonChain.start().compare(this.type.ordinal(), that.type.ordinal());
            int[] left = this.versionIdentifiers;
            int[] right = that.versionIdentifiers;
            if (left.length < right.length) {
                left = Arrays.copyOf(left, right.length);
            } else if (left.length > right.length) {
                right = Arrays.copyOf(right, left.length);
            }
            for (int i = 0; i < left.length; ++i) {
                comparisonChain = comparisonChain.compare(left[i], right[i]);
            }
            return comparisonChain.result();
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.type, this.version});
        }

        public boolean equals(Object object) {
            if (!(object instanceof Build)) {
                return false;
            }
            Build that = (Build)object;
            return Objects.equals((Object)this.type, (Object)that.type) && Objects.equals(this.version, that.version);
        }

        public String toString() {
            return this.type.format(this.version);
        }

        private static enum Type {
            SNAPSHOT("snapshot"),
            ALPHA("alpha"),
            BETA("beta"),
            RC("rc"),
            FINAL(null);

            private final String name;

            private Type(String name) {
                this.name = name;
            }

            String format(String version) {
                if (this.name == null) {
                    return null;
                }
                if ("snapshot".equals(this.name)) {
                    return "SNAPSHOT";
                }
                return String.format("%s%s", this.name, version);
            }

            public String toString() {
                return this.name;
            }
        }
    }
}

