/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils.serializer;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.Serializer;
import com.esotericsoftware.kryo.io.ByteBufferOutput;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.esotericsoftware.kryo.util.Pool;
import com.esotericsoftware.minlog.Log;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.atomix.utils.serializer.BufferAwareByteArrayOutputStream;
import io.atomix.utils.serializer.ByteArrayOutput;
import io.atomix.utils.serializer.CompatibleKryoPool;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Namespace {
    static final int FLOATING_ID = -1;
    static final String NO_NAME = "(no name)";
    private static final Logger LOGGER = LoggerFactory.getLogger(Namespace.class);
    private static final int DEFAULT_BUFFER_SIZE = 4096;
    private static final int MAX_OUTPUT_BUFFER_SIZE = 786432;
    private static final int MAX_POOLED_BUFFER_SIZE = 524288;
    private static final int INITIAL_ID = 16;
    private final Pool<Kryo> kryoPool;
    private final Pool<ByteArrayOutput> outputPool = new Pool<ByteArrayOutput>(this, true, true){

        protected ByteArrayOutput create() {
            return new ByteArrayOutput(4096, 786432, new BufferAwareByteArrayOutputStream(4096));
        }

        public void free(ByteArrayOutput output) {
            if (output.getByteArrayOutputStream().getBufferSize() < 524288) {
                output.getByteArrayOutputStream().reset();
                output.reset();
                super.free((Object)output);
            }
        }
    };
    private final Pool<Input> inputPool = new Pool<Input>(this, true, true){

        protected Input create() {
            return new Input(4096);
        }

        public void free(Input input) {
            if (input.getBuffer().length < 524288) {
                input.reset();
                input.setInputStream(null);
                super.free((Object)input);
            }
        }
    };
    private final ImmutableList<RegistrationBlock> registeredBlocks;
    private final String friendlyName;

    public Namespace(List<RegistrationBlock> registeredTypes, String friendlyName) {
        this.registeredBlocks = ImmutableList.copyOf(registeredTypes);
        this.friendlyName = (String)Preconditions.checkNotNull((Object)friendlyName);
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        this.kryoPool = new CompatibleKryoPool(friendlyName, classLoader, registeredTypes);
        this.kryoPool.free((Object)((Kryo)this.kryoPool.obtain()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] serialize(Object obj) {
        ByteArrayOutput output = (ByteArrayOutput)((Object)this.outputPool.obtain());
        try {
            Kryo kryo = (Kryo)this.kryoPool.obtain();
            try {
                kryo.writeClassAndObject((Output)output, obj);
            }
            finally {
                this.kryoPool.free((Object)kryo);
            }
            output.flush();
            byte[] byArray = output.getByteArrayOutputStream().toByteArray();
            return byArray;
        }
        finally {
            this.outputPool.free((Object)output);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Object obj, ByteBuffer buffer) {
        Kryo kryo = (Kryo)this.kryoPool.obtain();
        try (ByteBufferOutput output = new ByteBufferOutput(buffer);){
            kryo.writeClassAndObject((Output)output, obj);
        }
        finally {
            this.kryoPool.free((Object)kryo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T deserialize(byte[] bytes) {
        Input input = (Input)this.inputPool.obtain();
        try {
            Object object;
            Kryo kryo = (Kryo)this.kryoPool.obtain();
            try {
                input.setInputStream((InputStream)new ByteArrayInputStream(bytes));
                object = kryo.readClassAndObject(input);
            }
            catch (Throwable throwable) {
                this.kryoPool.free((Object)kryo);
                throw throwable;
            }
            this.kryoPool.free((Object)kryo);
            return (T)object;
        }
        finally {
            this.inputPool.free((Object)input);
        }
    }

    public ImmutableList<RegistrationBlock> getRegisteredBlocks() {
        return this.registeredBlocks;
    }

    public String toString() {
        if (!this.friendlyName.equals(NO_NAME)) {
            return MoreObjects.toStringHelper(this.getClass()).omitNullValues().add("friendlyName", (Object)this.friendlyName).toString();
        }
        return MoreObjects.toStringHelper(this.getClass()).add("registeredBlocks", this.registeredBlocks).toString();
    }

    static {
        Log.NONE();
    }

    static final class RegistrationBlock {
        private final int begin;
        private final ImmutableList<Pair<Class<?>[], Serializer<?>>> types;

        RegistrationBlock(int begin, List<Pair<Class<?>[], Serializer<?>>> types) {
            this.begin = begin;
            this.types = ImmutableList.copyOf(types);
        }

        public int begin() {
            return this.begin;
        }

        public ImmutableList<Pair<Class<?>[], Serializer<?>>> types() {
            return this.types;
        }

        public int hashCode() {
            return this.types.hashCode();
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof RegistrationBlock) {
                RegistrationBlock that = (RegistrationBlock)obj;
                return Objects.equals(this.types, that.types);
            }
            return false;
        }

        public String toString() {
            return MoreObjects.toStringHelper(this.getClass()).add("begin", this.begin).add("types", this.types).toString();
        }
    }

    public static final class Builder {
        private int blockHeadId = 16;
        private List<Pair<Class<?>[], Serializer<?>>> types = new ArrayList();
        private final List<RegistrationBlock> blocks = new ArrayList<RegistrationBlock>();
        private String name = "(no name)";

        public Namespace build() {
            if (!this.types.isEmpty()) {
                this.blocks.add(new RegistrationBlock(this.blockHeadId, this.types));
            }
            return new Namespace(this.blocks, this.name);
        }

        public Builder name(String name) {
            this.name = name;
            return this;
        }

        public String getName() {
            return this.name;
        }

        public Builder nextId(int id) {
            if (!this.types.isEmpty()) {
                if (id != -1 && id < this.blockHeadId + this.types.size() && LOGGER.isWarnEnabled()) {
                    LOGGER.warn("requested nextId {} could potentially overlap with existing registrations {}+{} ", new Object[]{id, this.blockHeadId, this.types.size(), new RuntimeException()});
                }
                this.blocks.add(new RegistrationBlock(this.blockHeadId, this.types));
                this.types = new ArrayList();
            }
            this.blockHeadId = id;
            return this;
        }

        public Builder register(Class<?> ... expectedTypes) {
            for (Class<?> clazz : expectedTypes) {
                this.types.add(Pair.of((Object)new Class[]{clazz}, null));
            }
            return this;
        }

        public Builder register(Serializer<?> serializer, Class<?> ... classes) {
            for (Class<?> clazz : classes) {
                this.types.add(Pair.of((Object)new Class[]{clazz}, (Object)((Serializer)Preconditions.checkNotNull(serializer))));
            }
            return this;
        }

        private void register(RegistrationBlock block) {
            if (block.begin() != -1) {
                this.nextId(block.begin());
                this.blocks.add(block);
                this.nextId(block.begin() + block.types().size());
            } else {
                int addedBlockBegin = this.blockHeadId + this.types.size();
                this.nextId(addedBlockBegin);
                this.blocks.add(new RegistrationBlock(addedBlockBegin, (List<Pair<Class<?>[], Serializer<?>>>)block.types()));
                this.nextId(addedBlockBegin + block.types().size());
            }
        }

        public Builder register(Namespace ns) {
            if (this.blocks.containsAll((Collection<?>)ns.getRegisteredBlocks())) {
                LOGGER.debug("Ignoring {}, already registered.", (Object)ns);
                return this;
            }
            for (RegistrationBlock block : ns.getRegisteredBlocks()) {
                this.register(block);
            }
            return this;
        }
    }
}

