/*
 * Decompiled with CFR 0.152.
 */
package io.atomix.utils;

import io.camunda.zeebe.util.SemanticVersion;
import java.util.Objects;

public final class Version
implements Comparable<Version> {
    private final int major;
    private final int minor;
    private final int patch;
    private final String build;
    private final String metadata;

    private Version(int major, int minor, int patch, String build, String metadata) {
        this.major = major;
        this.minor = minor;
        this.patch = patch;
        this.build = build;
        this.metadata = metadata;
    }

    public int major() {
        return this.major;
    }

    public int minor() {
        return this.minor;
    }

    public int patch() {
        return this.patch;
    }

    public String preRelease() {
        return this.build;
    }

    public String buildMetadata() {
        return this.metadata;
    }

    public static Version from(String version) {
        SemanticVersion semanticVersion = (SemanticVersion)SemanticVersion.parse((String)version).orElseThrow(() -> new IllegalArgumentException("Expected to parse valid semantic version, but got [%s]".formatted(version)));
        return new Version(semanticVersion.major(), semanticVersion.minor(), semanticVersion.patch(), semanticVersion.preRelease(), semanticVersion.buildMetadata());
    }

    @Override
    public int compareTo(Version that) {
        return this.toSemanticVersion().compareTo(that.toSemanticVersion());
    }

    public int hashCode() {
        return Objects.hash(this.major, this.minor, this.patch, this.build);
    }

    public boolean equals(Object object) {
        if (!(object instanceof Version)) {
            return false;
        }
        Version that = (Version)object;
        return this.major == that.major && this.minor == that.minor && this.patch == that.patch && Objects.equals(this.build, that.build);
    }

    public String toString() {
        return this.toSemanticVersion().toString();
    }

    private SemanticVersion toSemanticVersion() {
        return new SemanticVersion(this.major, this.minor, this.patch, this.build, null);
    }
}

